package org.phosphoresce.socket.proxy.http.server;

import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.velocity.app.Velocity;
import org.phosphoresce.commons.util.ArgumentsUtil;
import org.phosphoresce.socket.proxy.http.HttpReverseProxySetting;
import org.phosphoresce.socket.proxy.http.config.HttpReverseProxyConfig;

/**
 * HTTPリバースプロキシサーバー実行クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/08	Kitagawa		新規作成
 *-->
 */
public class HttpReverseProxyServerStartup {

	/** ロギングオブジェクト */
	private static Log log = LogFactory.getLog(HttpReverseProxyServerStartup.class);

	/**
	 * コンストラクタ<br>
	 */
	private HttpReverseProxyServerStartup() {
		super();
	}

	/**
	 * メインメソッド<br>
	 * @param args コマンドライン引数
	 * @throws Throwable 予期せぬ例外が発生した場合にスローされます
	 */
	public static void main(String[] args) throws Throwable {
		// 環境設定処理
		initializeSetting(args);
		initializeLog4J();
		initializeVelocity();

		// 環境妥当性チェック
		validityCheckConfig();

		log.info("Server startup succeeded.");

		// プロキシサーバーインスタンス実行
		HttpReverseProxyServer server = new HttpReverseProxyServer();
		server.execute();
	}

	/**
	 * アプリケーションセッティングを初期化します。<br>
	 * @param args コマンドライン引数
	 * @throws Throwable 処理中に予期せぬ例外が発生した場合にスローされます
	 */
	private static void initializeSetting(String[] args) throws Throwable {
		HttpReverseProxySetting setting = HttpReverseProxySetting.instance();
		// サーバー環境設定ファイル配置パス設定
		if (ArgumentsUtil.hasArgument(args, "-confpath", true)) {
			setting.setConfigPath(ArgumentsUtil.getArgument(args, "-confpath", true));
		}
		// サーバー環境設定ファイル名設定
		if (ArgumentsUtil.hasArgument(args, "-confname", true)) {
			setting.setConfigName(ArgumentsUtil.getArgument(args, "-confname", true));
		}
		// サーバー起動時刻設定
		setting.setCurrentTime(System.currentTimeMillis());
	}

	/**
	 * Log4J関連環境設定情報を初期化します。<br>
	 * @throws Throwable 環境設定情報処理中に予期せぬ例外が発生した場合にスローされます
	 */
	private static void initializeLog4J() throws Throwable {
		HttpReverseProxySetting setting = HttpReverseProxySetting.instance();
		HttpReverseProxyConfig config = HttpReverseProxyConfig.instance();
		String configPath = setting.getConfigPath() + "/" + config.getServerLog4JConfig();
		DOMConfigurator.configure(configPath);
		log.info("Server logging framework Log4J initialized (" + configPath + ").");
	}

	/**
	 * Velocity関連環境設定情報を初期化します。<br>
	 * @throws Throwable 環境設定情報処理中に予期せぬ例外が発生した場合にスローされます
	 */
	private static void initializeVelocity() throws Throwable {
		HttpReverseProxySetting setting = HttpReverseProxySetting.instance();
		HttpReverseProxyConfig config = HttpReverseProxyConfig.instance();
		String configPath = setting.getConfigPath() + "/" + config.getServerContentVelocityConfig();
		FileInputStream stream = new FileInputStream(configPath);
		Properties properties = new Properties();
		properties.load(stream);
		stream.close();
		Velocity.init(properties);
		log.info("Server template frameword Velocity initialized (" + configPath + ").");
	}

	/**
	 * 環境初期化後の妥当性チェックを行います。<br>
	 * @throws Throwable 処理中に予期せぬ例外が発生した場合にスローされます
	 */
	private static void validityCheckConfig() throws Throwable {
		HttpReverseProxyConfig config = HttpReverseProxyConfig.instance();
		HttpReverseProxySetting setting = HttpReverseProxySetting.instance();
		if (config.getReciveRequestHandlerCount() <= 0) {
			log.warn("No exist recive request handler");
		}
		if (config.getForwardResponseHandlerCount() <= 0) {
			log.warn("No exist forward response handler");
		}
		if (config.getForwardingConfigCount() <= 0) {
			log.warn("No exist forward configuration");
		}
		//		if (config.getRedirectingConfigCount() <= 0) {
		//			log.warn("no exist redirect configuration");
		//		}
	}
}
