package org.phosphoresce.socket.proxy.http.handler;

import java.net.Socket;

import org.phosphoresce.commons.socket.http.container.HttpSocketRequest;
import org.phosphoresce.commons.socket.http.container.HttpSocketResponse;
import org.phosphoresce.socket.proxy.http.config.HttpReverseProxyConfig;
import org.phosphoresce.socket.proxy.http.session.HttpReverseProxyControllerSession;
import org.phosphoresce.socket.proxy.http.session.HttpReverseProxyServerSession;

/**
 * HTTPリバースプロキシアプリケーションレスポンス補正ハンドラークラス<br>
 * <br>
 * 当ハンドラクラスは以下の仕様で動作させることを想定しています。<br>
 * <b>前提</b>
 * ・コントローラーセッションにクライアントソケットオブジェクトが設定されていること<br>
 * ・コントローラーセッションにクライアントリクエスト情報が設定されていること<br>
 * ・コントローラーセッションに転送先ソケットオブジェクトが設定されていること<br>
 * ・コントローラーセッションに転送先レスポンス情報が設定されていること<br>
 * <br>
 * <b>処理</b>
 * ・レスポンス転送するための転送先レスポンス情報を補正<br>
 * <br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/17	Kitagawa		新規作成
 *-->
 */
public class ForwardResponseValidateHandler extends HttpReverseProxyHandlerAdapter {

	/**
	 * コンストラクタ<br>
	 * @param serverSession サーバーセッションオブジェクト
	 * @param controllerSession コントローラーセッションオブジェクト
	 */
	public ForwardResponseValidateHandler(HttpReverseProxyServerSession serverSession, HttpReverseProxyControllerSession controllerSession) {
		super(serverSession, controllerSession);
	}

	/**
	 * イベントハンドル処理を実行します。<br>
	 * @return イベントハンドル処理後、プロキシコントローラーの後続処理を実施する場合にtrueを返却
	 * @throws Throwable 正常にイベントハンドル処理が行えなかった場合にスローされます
	 * @see org.phosphoresce.socket.proxy.http.handler.HttpReverseProxyHandler#execute()
	 */
	public boolean execute() throws Throwable {
		// 共通フィールド取得
		HttpReverseProxyConfig config = HttpReverseProxyConfig.instance();
		HttpReverseProxyServerSession serverSession = getServerSession();
		HttpReverseProxyControllerSession controllerSession = getControllerSession();
		Socket clientSocket = getClientSocket();
		String clientAddress = getClientSocket().getInetAddress().getHostAddress();
		HttpSocketRequest request = getRequest();
		HttpSocketResponse response = getResponse();

		// レスポンス転送するための転送先レスポンス情報を補正
		// TODO レスポンスにおけるLocationヘッダの補正が必要か
		//		// Locationヘッダ補正
		//		if (response.containsHeader("Location")) {
		//			String value = response.getHeaderValueOfString("Location");
		//			if (value.startsWith("http")) {
		//				StringBuffer location = new StringBuffer();
		//				location.append(config.isServerSSLEnabled() ? "https://" : "http://");
		//				location.append(config.getServerAddress());
		//				location.append(":");
		//				location.append(config.getServerPort());
		//				location.append(new URL(value).getFile());
		//
		//				response.putHeader("Location", location.toString());
		//			}
		//		}
		// TODO レスポンスにおけるContent-Locationヘッダの補正が必要か
		// Content-Locationヘッダ補正
		//		if (response.containsHeader("Content-Location")) {
		//			String value = response.getHeaderValueOfString("Content-Location");
		//			if (value.startsWith("http")) {
		//				StringBuffer location = new StringBuffer();
		//				location.append(config.isServerSSLEnabled() ? "https://" : "http://");
		//				location.append(config.getServerAddress());
		//				location.append(":");
		//				location.append(config.getServerPort());
		//				location.append(new URL(value).getFile());
		//
		//				response.putHeader("Content-Location", location.toString());
		//			}
		//		}

		return true;
	}
}
