package org.phosphoresce.socket.proxy.http.exception;

/**
 * 未定義の転送先ホストマッピングが操作された際の例外クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/08	Kitagawa		新規作成
 *-->
 */
public class NoSuchForwardMappingException extends Exception {

	/** フォワードコンテキスト */
	private String context;

	/**
	 * コンストラクタ<br>
	 */
	private NoSuchForwardMappingException() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param context フォワードコンテキスト
	 */
	public NoSuchForwardMappingException(String context) {
		super("no such forward mapping [" + context + "]");
		this.context = context;
	}

	/**
	 * フォワードコンテキストを取得します。<br>
	 * @return フォワードコンテキスト
	 */
	public String getContext() {
		return context;
	}
}
