package org.phosphoresce.socket.proxy.http.exception;

/**
 * 環境定義に関する例外クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/27	Kitagawa		新規作成
 *-->
 */
public class ConfigureException extends Exception {

	/** 対象リソース */
	private String resource;

	/** 例外メッセージ */
	private String exceptionMessage;

	/**
	 * コンストラクタ<br>
	 */
	private ConfigureException() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param resource 対象リソース
	 * @param exceptionMessage 例外メッセージ
	 */
	public ConfigureException(String resource, String exceptionMessage) {
		super(exceptionMessage + " (" + resource + ")");
		this.resource = resource;
		this.exceptionMessage = exceptionMessage;
	}
}
