package org.phosphoresce.socket.proxy.http.daemon.sample;

import org.phosphoresce.socket.proxy.http.daemon.HttpReverseProxyDaemon;

/**
 * 定期的にガベージコレクションを明示的に発行するサンプルデーモンクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/12/08	Kitagawa		新規作成
 *-->
 */
public class GarbageCollectionDaemon extends HttpReverseProxyDaemon {

	/**
	 * コンストラクタ<br>
	 * @param name デーモン名 
	 * @param loopDelay サービスデーモンループ処理時の間隔(ミリ秒)
	 * @param loopCount デーモンサービスのループカウント(負数で永続的ループ)
	 * @param retryCountOnError デーモンサービス処理中にエラーが発生した場合のリトライ回数(負数で永続的ループ)
	 */
	public GarbageCollectionDaemon(String name, long loopDelay, int loopCount, int retryCountOnError) {
		super(name, loopDelay, loopCount, retryCountOnError);
	}

	/**
	 * デーモンサービス処理を実行します。<br>
	 * @throws Throwable 処理中に予期せぬエラーが発生した場合にスローされます
	 * @see org.phosphoresce.socket.proxy.http.daemon.HttpReverseProxyDaemon#execute()
	 */
	public void execute() throws Throwable {
		System.gc();
		Runtime.getRuntime().gc();
		log.debug("Garbage Collect (free memory=" + Runtime.getRuntime().freeMemory() + ")");
	}
}
