package org.phosphoresce.socket.proxy.http.config;

import java.io.Serializable;

/**
 * HTTPリバースプロキシサーバーデーモン定義クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/08	Kitagawa		新規作成
 *-->
 */
public class ServerDaemonConfig implements Serializable {

	/** デーモンクラス */
	private Class daemonClass;

	/** デーモン名 */
	private String name;

	/** サービスデーモンループ処理時の間隔(ミリ秒) */
	private long loopDelay;

	/** デーモンサービスのループカウント */
	private int loopCount;

	/** デーモンサービス処理中にエラーが発生した場合のリトライ回数 */
	private int retryCountOnError;

	/**
	 * コンストラクタ<br>
	 * @param daemonClass デーモンクラス
	 * @param name デーモン名
	 * @param loopDelay サービスデーモンループ処理時の間隔(ミリ秒)
	 * @param loopCount デーモンサービスのループカウント
	 * @param retryCountOnError デーモンサービス処理中にエラーが発生した場合のリトライ回数
	 */
	public ServerDaemonConfig(Class daemonClass, String name, long loopDelay, int loopCount, int retryCountOnError) {
		super();
		this.daemonClass = daemonClass;
		this.name = name;
		this.loopDelay = loopDelay;
		this.loopCount = loopCount;
		this.retryCountOnError = retryCountOnError;
	}

	/**
	 * コンストラクタ<br>
	 */
	public ServerDaemonConfig() {
		this(null, null, 1000, -1, -1);
	}

	/**
	 * デーモンクラスを取得します。<br>
	 * @return デーモンクラス
	 */
	public Class getDaemonClass() {
		return daemonClass;
	}

	/**
	 * デーモンクラスを設定します。<br>
	 * @param daemonClass デーモンクラス
	 */
	public void setDaemonClass(Class daemonClass) {
		this.daemonClass = daemonClass;
	}

	/**
	 * デーモンサービスのループカウントを取得します。<br>
	 * @return デーモンサービスのループカウント
	 */
	public int getLoopCount() {
		return loopCount;
	}

	/**
	 * デーモンサービスのループカウントを設定します。<br>
	 * @param loopCount デーモンサービスのループカウント
	 */
	public void setLoopCount(int loopCount) {
		this.loopCount = loopCount;
	}

	/**
	 * サービスデーモンループ処理時の間隔(ミリ秒)を取得します。<br>
	 * @return サービスデーモンループ処理時の間隔(ミリ秒)
	 */
	public long getLoopDelay() {
		return loopDelay;
	}

	/**
	 * サービスデーモンループ処理時の間隔(ミリ秒)を設定します。<br>
	 * @param loopDelay サービスデーモンループ処理時の間隔(ミリ秒)
	 */
	public void setLoopDelay(long loopDelay) {
		this.loopDelay = loopDelay;
	}

	/**
	 * デーモン名を取得します。<br>
	 * @return デーモン名
	 */
	public String getName() {
		return name;
	}

	/**
	 * デーモン名を設定します。<br>
	 * @param name デーモン名
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * デーモンサービス処理中にエラーが発生した場合のリトライ回数を取得します。<br>
	 * @return デーモンサービス処理中にエラーが発生した場合のリトライ回数
	 */
	public int getRetryCountOnError() {
		return retryCountOnError;
	}

	/**
	 * デーモンサービス処理中にエラーが発生した場合のリトライ回数を設定します。<br>
	 * @param retryCountOnError デーモンサービス処理中にエラーが発生した場合のリトライ回数
	 */
	public void setRetryCountOnError(int retryCountOnError) {
		this.retryCountOnError = retryCountOnError;
	}

	/**
	 * オブジェクトの文字列表現を返します。<br>
	 * @return オブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("daemonClass=");
		buffer.append(daemonClass);
		buffer.append(",");
		buffer.append("name=");
		buffer.append(name);
		buffer.append(",");
		buffer.append("loopDelay=");
		buffer.append(loopDelay);
		buffer.append(",");
		buffer.append("loopCount=");
		buffer.append(loopCount);
		buffer.append(",");
		buffer.append("retryCountOnError=");
		buffer.append(retryCountOnError);
		buffer.append("}");
		return buffer.toString();
	}
}
