package org.phosphoresce.socket.proxy.http.config;

import java.io.Serializable;

/**
 * HTTPリバースプロキシリレーマッピング定義クラス<br>
 * <br>
 * 当クラスは特定のURL(正規表現)に合致するリクエストが行われた場合に
 * 他のアドレスに対してのプロキシ処理を行うための環境情報を管理します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/08	Kitagawa		新規作成
 *-->
 */
public class RequestForwardConfig implements Serializable {

	/** セッション保持キー */
	public static final String SESSION_KEY = RequestForwardConfig.class.getName();

	/** マッピング対象URL正規表現 */
	private String matchUrl;

	/** 転送先アドレス */
	private String forwardAddress;

	/** 転送先ポート */
	private int forwardPort;

	/**
	 * コンストラクタ<br>
	 */
	public RequestForwardConfig() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param matchUrl マッピング対象URL正規表現
	 * @param forwardAddress リレー先アドレス
	 * @param forwardPort リレー先ポート
	 */
	public RequestForwardConfig(String matchUrl, String forwardAddress, int forwardPort) {
		super();
		this.matchUrl = matchUrl;
		this.forwardAddress = forwardAddress;
		this.forwardPort = forwardPort;
	}

	/**
	 * マッピング対象URL正規表現を取得します。<br>
	 * @return マッピング対象URL正規表現
	 */
	public String getMatchUrl() {
		return matchUrl;
	}

	/**
	 * マッピング対象URL正規表現を設定します。<br>
	 * @param matchUrl マッピング対象URL正規表現
	 */
	public void setMatchUrl(String matchUrl) {
		this.matchUrl = matchUrl;
	}

	/**
	 * 転送先アドレスを取得します。<br>
	 * @return 転送先アドレス
	 */
	public String getForwardAddress() {
		return forwardAddress;
	}

	/**
	 * 転送先アドレスを設定します。<br>
	 * @param forwardAddress 転送先アドレス
	 */
	public void setForwardAddress(String forwardAddress) {
		this.forwardAddress = forwardAddress;
	}

	/**
	 * 転送先ポートを取得します。<br>
	 * @return 転送先ポート
	 */
	public int getForwardPort() {
		return forwardPort;
	}

	/**
	 * 転送先ポートを設定します。<br>
	 * @param forwardPort 転送先ポート
	 */
	public void setForwardPort(int forwardPort) {
		this.forwardPort = forwardPort;
	}

	/**
	 * オブジェクトの文字列表現を返します。<br>
	 * @return オブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("matchUrl=");
		buffer.append(matchUrl);
		buffer.append(",");
		buffer.append("forwardAddress=");
		buffer.append(forwardAddress);
		buffer.append(",");
		buffer.append("forwardPort=");
		buffer.append(forwardPort);
		buffer.append("}");
		return buffer.toString();
	}
}
