package org.phosphoresce.socket.proxy.http;

import java.io.Serializable;

/**
 * HTTPリバースプロキシグローバル定数<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/08	Kitagawa		新規作成
 *-->
 */
public final class HttpReverseProxyGlobal implements Serializable {

	/** リバースプロキシサーバースレッドディレイタイム */
	public static final long SERVER_THREAD_DELAY = 1;

	/** HTTPヘッダ日付フォーマット */
	public static final String HTTP_HEADER_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

	/** Velocityコンテンツバインドキー(サーバー環境定義オブジェクト) */
	public static final String VELOCITY_BIND_KEY_CONFIG = "config";

	/** Velocityコンテンツバインドキー(サーバーセッション) */
	public static final String VELOCITY_BIND_KEY_SERVER_SESSION = "serverSession";

	/** Velocityコンテンツバインドキー(コントローラーセッション) */
	public static final String VELOCITY_BIND_KEY_CONTROLLER_SESSION = "controllerSession";

	/**
	 * コンストラクタ<br>
	 */
	private HttpReverseProxyGlobal() {
		super();
	}
}
