package org.phosphoresce.launcher.util;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.phosphoresce.launcher.LauncherConstants;
import org.phosphoresce.launcher.LauncherSession;
import org.phosphoresce.launcher.exception.ClassLoaderException;

/**
 * JavaAvP[VNc[ʃ[eBeBNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2006/10/12	Kitagawa		VK쐬
 * 2008/11/26	Kitagawa		outputErrorG[Oo̓t@CύX
 *-->
 */
public final class LauncherUtil implements LauncherConstants {

	/** G[Ot@CvtBNX */
	public static final String ERROR_LOG_PREFIX = "launcher-error-";

	/** G[Ot@C^CX^v */
	public static final String ERROR_LOG_TIMESTAMP = "yyyyMMddHHmmss";

	/** G[Ot@Cgq */
	public static final String ERROR_LOG_EXTENSION = ".log";

	/**
	 * RXgN^<br>
	 */
	private LauncherUtil() {
		//
	}

	/**
	 * w肳ꂽt@CCut@Cł邩肵܂B<br>
	 * w肳ꂽt@CpX݂ȂꍇnullIuWFNgō݂ꍇ̓Cuł͂ȂƔf܂B<br>
	 * @param filename Ώۃt@CpX
	 * @return w肳ꂽt@CpXCut@CłꍇAtrueԋp
	 */
	public static boolean isLibrary(String filename) {
		if (!StringUtil.isEmpty(filename)) {
			File file = new File(filename);
			if (file.exists() && file.isFile()) {
				for (int i = 0; i <= LIBRARY_EXTENSTIONS.length - 1; i++) {
					if (file.getAbsolutePath().toUpperCase().endsWith("." + LIBRARY_EXTENSTIONS[i].toUpperCase())) {
						return true;
					}
				}
			}
		}
		return false;
	}

	/**
	 * NXێĂ蓮IɃNX[_[𐶐܂B<br>
	 * @return ClassLoaderIuWFNg
	 * @throws ClassLoaderException ɃNX[_[IuWFNgłȂꍇɔ
	 */
	public static ClassLoader createClassLoader(LauncherSession session) throws ClassLoaderException {
		try {
			URL[] urls = session.getLibraryURLs();

			if (session.isDebug()) {
				System.out.println("-- ClassLoader Load Library");
				for (int i = 0; i <= urls.length - 1; i++) {
					System.out.println(" " + urls[i]);
				}
			}

			return URLClassLoader.newInstance(urls);
		} catch (Exception e) {
			throw new ClassLoaderException("ZbVێĂNX̃[hɎs܂", e);
		}
	}

	/**
	 * w肳ꂽbZ[WƗOOt@Cɏo͂܂B<br>
	 * @param message bZ[W
	 * @param throwable OIuWFNg
	 */
	public static void outputError(String message, Throwable throwable) {
		SimpleDateFormat format = new SimpleDateFormat(ERROR_LOG_TIMESTAMP);
		String filename = ERROR_LOG_PREFIX + format.format(new Date()) + ERROR_LOG_EXTENSION;

		StringWriter stringWriter = new StringWriter();
		PrintWriter printWriter = new PrintWriter(stringWriter);

		throwable.printStackTrace();
		throwable.printStackTrace(printWriter);

		try {
			PrintWriter writer = new PrintWriter(new FileWriter(filename));
			writer.println(message);
			writer.println(stringWriter.toString());
			writer.flush();
			writer.close();
		} catch (Exception e) {
			System.err.println("G[Õt@Co͒ɓo͗O܂");
			e.printStackTrace();
		}
	}
}
