package org.phosphoresce.launcher.exception;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * NX[_̗ONX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2006/10/12	Kitagawa		VK쐬
 * 2007/09/24	Kitagawa		JDK1.3Ήׂ̈Exception(String, Throwable)𖢎gpƂ
 *-->
 */
public class ClassLoaderException extends Exception {

	/** [gP[XOIuWFNg */
	private Throwable parent = null;

	/**
	 * RXgN^<br>
	 */
	public ClassLoaderException() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param message ObZ[W
	 * @param cause [gP[X
	 */
	public ClassLoaderException(String message, Throwable cause) {
		super(message);
		this.parent = cause;
	}

	/**
	 * RXgN^<br>
	 * @param message ObZ[W
	 */
	public ClassLoaderException(String message) {
		super(message);
	}

	/**
	 * RXgN^<br>
	 * @param cause [gP[X
	 */
	public ClassLoaderException(Throwable cause) {
		super();
		this.parent = cause;
	}

	/**
	 * [gP[XOێ邩肵܂B<br>
	 * @return [gP[XOێꍇtrueԋp
	 */
	public final boolean hasParent() {
		return parent != null;
	}

	/**
	 * [gP[XO擾܂B<br>
	 * @return [gP[XOԋp܂B
	 */
	public final Throwable getParent() {
		return parent;
	}

	/**
	 * X^bNg[XWo͂ɏo͂܂B<br>
	 * @see java.lang.Throwable#printStackTrace()
	 */
	public void printStackTrace() {
		super.printStackTrace();
		if (hasParent()) {
			parent.printStackTrace();
		}
	}

	/**
	 * X^bNg[XPrintStreamɏo͂܂B<br>
	 * @param stream PrintStream
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintStream)
	 */
	public void printStackTrace(PrintStream stream) {
		super.printStackTrace(stream);
		if (hasParent()) {
			parent.printStackTrace(stream);
		}
	}

	/**
	 * X^bNg[XPrintWriterɏo͂܂B<br>
	 * @param writer PrintWriter
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintWriter)
	 */
	public void printStackTrace(PrintWriter writer) {
		super.printStackTrace(writer);
		if (hasParent()) {
			parent.printStackTrace(writer);
		}
	}
}
