package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.common.BrowserFramePanel;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

/**
 * NG[}l[Wpl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class QueryManagePanel extends BrowserFramePanel {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** VOgZtCX^X */
	private static QueryManagePanel instance = null;

	/** f[^x[XZbVnbVR[h */
	private int databaseSessionHashCode = 0;

	/**
	 * RXgN^<br>
	 */
	private QueryManagePanel() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static QueryManagePanel instance() {
		if (instance == null) {
			instance = new QueryManagePanel();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		if (DatabaseBrowserSession.instance().getDatabaseSession(QueryManageConstants.DBSESSION_KEY).hashCode() != databaseSessionHashCode) {
			databaseSessionHashCode = DatabaseBrowserSession.instance().getDatabaseSession(QueryManageConstants.DBSESSION_KEY).hashCode();
			QueryManageEditorPane.instance().refresh();
		}
	}

	/**
	 * t[wb_^Cg擾܂B<br>
	 * @return t[wb_^Cg
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#getHeaderTitle()
	 */
	public String getHeaderTitle() {
		return "Query Manager";
	}

	/**
	 * t[wb_ڍ׃bZ[W擾܂B<br>
	 * @return t[wb_ڍ׃bZ[W
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#getHeaderDescription()
	 */
	public String getHeaderDescription() {
		return "Execute Select And Update Query.";
	}

	/**
	 * t[wb_ACR擾܂B<br>
	 * @return t[wb_ACR
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#getHeaderIcon()
	 */
	public Icon getHeaderIcon() {
		return new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_QUERY_48);
	}

	/**
	 * t[yCRecpl𐶐܂B<br>
	 * @return t[yCRecpl
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#createContentPanel()
	 */
	protected EPanel createContentPanel() {
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 1.0D;
		gridBagConstraints3.weighty = 1.0D;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 3;
		EPanel panel = new EPanel();
		panel.setLayout(new GridBagLayout());
		panel.add(QueryManageEditorPane.instance(), gridBagConstraints3);
		return panel;
	}
}
