package org.phosphoresce.dbbrowser.gui.panel.pcinformation;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EFieldSet;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * NCAgPCplR|[lgNX<br>
 * VXevpeBtB[hZbg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public final class SystemInformationFieldSet extends EFieldSet implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static SystemInformationFieldSet instance = null;

	/** OSx */
	private ELabel osNameLabel = null;

	/** OS */
	private ELabel osName = null;

	/** OSo[Wx */
	private ELabel osVersionLabel = null;

	/** OSo[W */
	private ELabel osVersion = null;

	/** OSA[LeN`x */
	private ELabel osArchitectureLabel = null;

	/** OSA[LeN` */
	private ELabel osArchitecture = null;

	/**
	 * RXgN^<br>
	 */
	private SystemInformationFieldSet() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static SystemInformationFieldSet instance() {
		if (instance == null) {
			instance = new SystemInformationFieldSet();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		Properties properties = System.getProperties();
		getOsName().setText(properties.getProperty("os.name"));
		getOsVersion().setText(properties.getProperty("os.version"));
		getOsArchitecture().setText(properties.getProperty("os.arch"));
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
		gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints6.fill = GridBagConstraints.BOTH;
		gridBagConstraints6.weightx = 1.0D;
		gridBagConstraints6.weighty = 0.0D;
		gridBagConstraints6.gridx = 1;
		gridBagConstraints6.gridy = 3;
		GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
		gridBagConstraints5.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints5.fill = GridBagConstraints.BOTH;
		gridBagConstraints5.weightx = 0.0D;
		gridBagConstraints5.weighty = 0.0D;
		gridBagConstraints5.gridx = 0;
		gridBagConstraints5.gridy = 3;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints4.fill = GridBagConstraints.BOTH;
		gridBagConstraints4.weightx = 1.0D;
		gridBagConstraints4.weighty = 0.0D;
		gridBagConstraints4.gridx = 1;
		gridBagConstraints4.gridy = 1;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 0.0D;
		gridBagConstraints3.weighty = 0.0D;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 1;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0D;
		gridBagConstraints2.weighty = 0.0D;
		gridBagConstraints2.gridx = 1;
		gridBagConstraints2.gridy = 0;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 0.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(500, 103));
		this.setPreferredSize(new Dimension(500, 103));
		this.setMinimumSize(new Dimension(500, 103));
		this.setMaximumSize(new Dimension(500, 103));
		this.setText("System Information");
		this.add(getOsNameLabel(), gridBagConstraints1);
		this.add(getOsName(), gridBagConstraints2);
		this.add(getOsVersionLabel(), gridBagConstraints3);
		this.add(getOsVersion(), gridBagConstraints4);
		this.add(getOsArchitectureLabel(), gridBagConstraints5);
		this.add(getOsArchitecture(), gridBagConstraints6);
	}

	/**
	 * OSx擾܂B<br>
	 * @return OSx
	 */
	private ELabel getOsNameLabel() {
		if (osNameLabel == null) {
			osNameLabel = new ELabel();
			osNameLabel.setPreferredSize(new Dimension(150, 22));
			osNameLabel.setText("OS Name :");
		}
		return osNameLabel;
	}

	/**
	 * OS擾܂B<br>
	 * @return OS
	 */
	private ELabel getOsName() {
		if (osName == null) {
			osName = new ELabel();
			osName.setPreferredSize(new Dimension(150, 22));
		}
		return osName;
	}

	/**
	 * OSo[Wx擾܂B<br>
	 * @return OSo[Wx
	 */
	private ELabel getOsVersionLabel() {
		if (osVersionLabel == null) {
			osVersionLabel = new ELabel();
			osVersionLabel.setPreferredSize(new Dimension(150, 22));
			osVersionLabel.setText("OS Version :");
		}
		return osVersionLabel;
	}

	/**
	 * OSo[W擾܂B<br>
	 * @return OSo[W
	 */
	private ELabel getOsVersion() {
		if (osVersion == null) {
			osVersion = new ELabel();
			osVersion.setPreferredSize(new Dimension(150, 22));
		}
		return osVersion;
	}

	/**
	 * OSA[LeN`x擾܂B<br>
	 * @return OSA[LeN`x
	 */
	private ELabel getOsArchitectureLabel() {
		if (osArchitectureLabel == null) {
			osArchitectureLabel = new ELabel();
			osArchitectureLabel.setPreferredSize(new Dimension(150, 22));
			osArchitectureLabel.setText("OS Architecture :");
		}
		return osArchitectureLabel;
	}

	/**
	 * OSA[LeN`擾܂B<br>
	 * @return OSA[LeN`
	 */
	private ELabel getOsArchitecture() {
		if (osArchitecture == null) {
			osArchitecture = new ELabel();
			osArchitecture.setPreferredSize(new Dimension(150, 22));
		}
		return osArchitecture;
	}
}
