package org.phosphoresce.dbbrowser.gui.panel.pcinformation;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EFieldSet;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * NCAgPCplR|[lgNX<br>
 * VXevpeBtB[hZbg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public final class JavaInformationFieldSet extends EFieldSet implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** VOgZtCX^X */
	private static JavaInformationFieldSet instance = null;

	/** ^Cx */
	private ELabel runtimeNameLabel = null;

	/** ^C */
	private ELabel runtimeName = null;

	/** x_[x */
	private ELabel vendorNameLabel = null;

	/** x_[ */
	private ELabel vendorName = null;

	/** VMo[Wx */
	private ELabel jvmVersionLabel = null;

	/** VMo[W */
	private ELabel jvmVersion = null;

	/**
	 * RXgN^<br>
	 */
	private JavaInformationFieldSet() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static JavaInformationFieldSet instance() {
		if (instance == null) {
			instance = new JavaInformationFieldSet();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		Properties properties = System.getProperties();
		getRuntimeName().setText(properties.getProperty("java.runtime.name"));
		getVendorName().setText(properties.getProperty("java.vm.vendor"));
		getJvmVersion().setText(properties.getProperty("java.vm.version"));
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
		gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints6.fill = GridBagConstraints.BOTH;
		gridBagConstraints6.weightx = 1.0D;
		gridBagConstraints6.weighty = 0.0D;
		gridBagConstraints6.gridx = 1;
		gridBagConstraints6.gridy = 3;
		GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
		gridBagConstraints5.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints5.fill = GridBagConstraints.BOTH;
		gridBagConstraints5.weightx = 0.0D;
		gridBagConstraints5.weighty = 0.0D;
		gridBagConstraints5.gridx = 0;
		gridBagConstraints5.gridy = 3;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints4.fill = GridBagConstraints.BOTH;
		gridBagConstraints4.weightx = 1.0D;
		gridBagConstraints4.weighty = 0.0D;
		gridBagConstraints4.gridx = 1;
		gridBagConstraints4.gridy = 1;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 0.0D;
		gridBagConstraints3.weighty = 0.0D;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 1;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0D;
		gridBagConstraints2.weighty = 0.0D;
		gridBagConstraints2.gridx = 1;
		gridBagConstraints2.gridy = 0;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 0.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(500, 100));
		this.setPreferredSize(new Dimension(500, 100));
		this.setMaximumSize(new Dimension(500, 100));
		this.setMinimumSize(new Dimension(500, 100));
		this.setText("Java Runtime Information");
		this.add(getRuntimeNameLabel(), gridBagConstraints1);
		this.add(getRuntimeName(), gridBagConstraints2);
		this.add(getVendorNameLabel(), gridBagConstraints3);
		this.add(getVendorName(), gridBagConstraints4);
		this.add(getJvmVersionLabel(), gridBagConstraints5);
		this.add(getJvmVersion(), gridBagConstraints6);
	}

	/**
	 * ^Cx擾܂B<br>
	 * @return ^Cx
	 */
	private ELabel getRuntimeNameLabel() {
		if (runtimeNameLabel == null) {
			runtimeNameLabel = new ELabel();
			runtimeNameLabel.setPreferredSize(new Dimension(150, 22));
			runtimeNameLabel.setText("Runtime Name :");
		}
		return runtimeNameLabel;
	}

	/**
	 * ^C擾܂B<br>
	 * @return ^C
	 */
	private ELabel getRuntimeName() {
		if (runtimeName == null) {
			runtimeName = new ELabel();
			runtimeName.setPreferredSize(new Dimension(150, 22));
		}
		return runtimeName;
	}

	/**
	 * x_[x擾܂B<br>
	 * @return x_[x
	 */
	private ELabel getVendorNameLabel() {
		if (vendorNameLabel == null) {
			vendorNameLabel = new ELabel();
			vendorNameLabel.setPreferredSize(new Dimension(150, 22));
			vendorNameLabel.setText("Vendor Name :");
		}
		return vendorNameLabel;
	}

	/**
	 * x_[擾܂B<br>
	 * @return x_[
	 */
	private ELabel getVendorName() {
		if (vendorName == null) {
			vendorName = new ELabel();
			vendorName.setPreferredSize(new Dimension(150, 22));
		}
		return vendorName;
	}

	/**
	 * VMo[Wx擾܂B<br>
	 * @return VMo[Wx
	 */
	private ELabel getJvmVersionLabel() {
		if (jvmVersionLabel == null) {
			jvmVersionLabel = new ELabel();
			jvmVersionLabel.setPreferredSize(new Dimension(150, 22));
			jvmVersionLabel.setText("JVM Version :");
		}
		return jvmVersionLabel;
	}

	/**
	 * VMo[W擾܂B<br>
	 * @return VMo[W
	 */
	private ELabel getJvmVersion() {
		if (jvmVersion == null) {
			jvmVersion = new ELabel();
			jvmVersion.setPreferredSize(new Dimension(150, 22));
		}
		return jvmVersion;
	}
}
