package org.phosphoresce.dbbrowser.gui.panel.pcinformation;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel;
import org.phosphoresce.dbbrowser.resource.image.DatabaseBrowserImages;

/**
 * NCAgPCpl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class ClientPCInformationPanel extends BrowserScrollableFramePanel {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static ClientPCInformationPanel instance = null;

	/** RecplXy[T[ */
	private ELabel contentsPanelSpacer = null;

	/**
	 * RXgN^<br>
	 */
	private ClientPCInformationPanel() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static ClientPCInformationPanel instance() {
		if (instance == null) {
			instance = new ClientPCInformationPanel();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		SystemInformationFieldSet.instance().refresh();
		JavaInformationFieldSet.instance().refresh();
	}

	/**
	 * t[wb_^Cg擾܂B<br>
	 * @return t[wb_^Cg
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#getHeaderTitle()
	 */
	public String getHeaderTitle() {
		return "Client PC Information";
	}

	/**
	 * t[wb_ڍ׃bZ[W擾܂B<br>
	 * @return t[wb_ڍ׃bZ[W
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#getHeaderDescription()
	 */
	public String getHeaderDescription() {
		return "Client Computer Informations.";
	}

	/**
	 * t[wb_ACR擾܂B<br>
	 * @return t[wb_ACR
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#getHeaderIcon()
	 */
	public Icon getHeaderIcon() {
		return new ImageIcon(DatabaseBrowserImages.IMAGE_ICON_CLIENTPC_48);
	}

	/**
	 * t[yCRecpl𐶐܂B<br>
	 * @return t[yCRecpl
	 * @see org.phosphoresce.dbbrowser.gui.common.BrowserScrollableFramePanel#createContentPanel()
	 */
	protected EPanel createContentPanel() {
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 1.0D;
		gridBagConstraints3.weighty = 1.0D;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 3;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0D;
		gridBagConstraints2.weighty = 0.0D;
		gridBagConstraints2.gridx = 0;
		gridBagConstraints2.gridy = 2;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.insets = new Insets(5, 5, 5, 5);
		gridBagConstraints.fill = GridBagConstraints.BOTH;
		gridBagConstraints.weightx = 1.0D;
		gridBagConstraints.weighty = 0.0D;
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		EPanel panel = new EPanel();
		panel.setLayout(new GridBagLayout());
		panel.add(SystemInformationFieldSet.instance(), gridBagConstraints);
		panel.add(JavaInformationFieldSet.instance(), gridBagConstraints2);
		panel.add(getContentsPanelSpacer(), gridBagConstraints3);
		return panel;
	}

	/**
	 * RecplXy[T[擾܂B<br>
	 * @return RecplXy[T[
	 */
	private ELabel getContentsPanelSpacer() {
		if (contentsPanelSpacer == null) {
			contentsPanelSpacer = new ELabel();
		}
		return contentsPanelSpacer;
	}
}
