package org.phosphoresce.dbbrowser.gui.panel.dbinformation;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;

import javax.swing.DefaultListModel;
import javax.swing.JScrollPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.DatabaseInformation;
import org.phosphoresce.commons.eswing.EFieldSet;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EList;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * f[^x[XplR|[lgNX<br>
 * f[^x[Xڍ׏tB[hZbg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class DatabaseDetailFieldSet extends EFieldSet implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(getClass());

	/** VOgZtCX^X */
	private static DatabaseDetailFieldSet instance = null;

	/** J^Ox_[̃x */
	private ELabel catalogTermLabel = null;

	/** J^Ox_[ */
	private ELabel catalogTerm = null;

	/** vV[Wx_[̃x */
	private ELabel procedureTermLabel = null;

	/** vV[Wx_[ */
	private ELabel procedureTerm = null;

	/** XL[}x_[̃x */
	private ELabel schemaTermLabel = null;

	/** XL[}x_[ */
	private ELabel schemaTerm = null;

	/** J^OZp[^x */
	private ELabel catalogSeparatorLabel = null;

	/** J^OZp[^ */
	private ELabel catalogSeparator = null;

	/** J^OXgx */
	private ELabel catalogListLabel = null;

	/** J^OXgXN[yC */
	private EScrollPane catalogListScrollPane = null;

	/** J^OXg */
	private EList catalogList = null;

	/** XL[}Xgx */
	private ELabel schemaListLabel = null;

	/** XL[}XgXN[yC */
	private EScrollPane schemaListScrollPane = null;

	/** XL[}Xg */
	private EList schemaList = null;

	/** e[u^CvXgx */
	private ELabel tableTypeListLabel = null;

	/** e[u^CvXgXN[yC */
	private EScrollPane tableTypeListScrollPane = null;

	/** e[u^CvXg */
	private EList tableTypeList = null;

	/** ^Cv񃊃Xgx */
	private ELabel typeInfoListLabel = null;

	/** ^Cv񃊃XgXN[yC */
	private EScrollPane typeInfoListScrollPane = null;

	/** ^Cv񃊃Xg */
	private EList typeInfoList = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseDetailFieldSet() {
		super();
		initialize();
	}

	/**
	 * VOgZtCX^X擾܂B<br>
	 * @return VOgZtCX^X
	 */
	public static DatabaseDetailFieldSet instance() {
		if (instance == null) {
			instance = new DatabaseDetailFieldSet();
		}
		return instance;
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		DatabaseInformation information = new DatabaseInformation(DatabaseBrowserSession.instance().getCommonDatabaseSession());
		getCatalogTerm().setText(information.getCatalogTerm());
		getProcedureTerm().setText(information.getProcedureTerm());
		getSchemaTerm().setText(information.getSchemaTerm());
		getCatalogSeparator().setText(information.getCatalogSeparator());
		DefaultListModel catalogListModel = new DefaultListModel();
		for (Iterator iterator = information.getCatalogNameList().iterator(); iterator.hasNext();) {
			catalogListModel.addElement(iterator.next());
		}
		getCatalogList().setModel(catalogListModel);
		DefaultListModel schemaListModel = new DefaultListModel();
		for (Iterator iterator = information.getSchemaNameList().iterator(); iterator.hasNext();) {
			schemaListModel.addElement(iterator.next());
		}
		getTableTypeList().setModel(schemaListModel);
		DefaultListModel tableTypeListModel = new DefaultListModel();
		for (Iterator iterator = information.getTableTypeNameList().iterator(); iterator.hasNext();) {
			tableTypeListModel.addElement(iterator.next());
		}
		getTableTypeList().setModel(tableTypeListModel);
		DefaultListModel typeInfoListModel = new DefaultListModel();
		for (Iterator iterator = information.getTypeInfoNameList().iterator(); iterator.hasNext();) {
			typeInfoListModel.addElement(iterator.next());
		}
		getTypeInfoList().setModel(typeInfoListModel);
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
		gridBagConstraints16.insets = new Insets(2, 0, 2, 0);
		gridBagConstraints16.anchor = GridBagConstraints.WEST;
		gridBagConstraints16.weightx = 1.0D;
		gridBagConstraints16.weighty = 0.0D;
		gridBagConstraints16.gridy = 8;
		gridBagConstraints16.gridx = 1;
		GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
		gridBagConstraints15.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints15.fill = GridBagConstraints.BOTH;
		gridBagConstraints15.weightx = 0.0D;
		gridBagConstraints15.weighty = 0.0D;
		gridBagConstraints15.gridx = 0;
		gridBagConstraints15.gridy = 8;
		GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
		gridBagConstraints14.insets = new Insets(2, 0, 2, 0);
		gridBagConstraints14.anchor = GridBagConstraints.WEST;
		gridBagConstraints14.weightx = 1.0D;
		gridBagConstraints14.weighty = 0.0D;
		gridBagConstraints14.gridy = 7;
		gridBagConstraints14.gridx = 1;
		GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
		gridBagConstraints13.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints13.fill = GridBagConstraints.BOTH;
		gridBagConstraints13.weightx = 0.0D;
		gridBagConstraints13.weighty = 0.0D;
		gridBagConstraints13.gridx = 0;
		gridBagConstraints13.gridy = 7;
		GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
		gridBagConstraints12.insets = new Insets(2, 0, 2, 0);
		gridBagConstraints12.anchor = GridBagConstraints.WEST;
		gridBagConstraints12.weightx = 1.0D;
		gridBagConstraints12.weighty = 0.0D;
		gridBagConstraints12.gridy = 6;
		gridBagConstraints12.gridx = 1;
		GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
		gridBagConstraints11.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints11.fill = GridBagConstraints.BOTH;
		gridBagConstraints11.weightx = 0.0D;
		gridBagConstraints11.weighty = 0.0D;
		gridBagConstraints11.gridx = 0;
		gridBagConstraints11.gridy = 6;
		GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
		gridBagConstraints10.insets = new Insets(2, 0, 2, 0);
		gridBagConstraints10.anchor = GridBagConstraints.WEST;
		gridBagConstraints10.weightx = 1.0D;
		gridBagConstraints10.weighty = 0.0D;
		gridBagConstraints10.gridy = 5;
		gridBagConstraints10.gridx = 1;
		GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
		gridBagConstraints9.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints9.fill = GridBagConstraints.BOTH;
		gridBagConstraints9.weightx = 0.0D;
		gridBagConstraints9.weighty = 0.0D;
		gridBagConstraints9.gridx = 0;
		gridBagConstraints9.gridy = 5;
		GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
		gridBagConstraints8.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints8.fill = GridBagConstraints.BOTH;
		gridBagConstraints8.weightx = 1.0D;
		gridBagConstraints8.weighty = 0.0D;
		gridBagConstraints8.gridx = 1;
		gridBagConstraints8.gridy = 4;
		GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
		gridBagConstraints7.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints7.fill = GridBagConstraints.BOTH;
		gridBagConstraints7.weightx = 0.0D;
		gridBagConstraints7.weighty = 0.0D;
		gridBagConstraints7.gridx = 0;
		gridBagConstraints7.gridy = 4;
		GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
		gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints6.fill = GridBagConstraints.BOTH;
		gridBagConstraints6.weightx = 1.0D;
		gridBagConstraints6.weighty = 0.0D;
		gridBagConstraints6.gridx = 1;
		gridBagConstraints6.gridy = 3;
		GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
		gridBagConstraints5.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints5.fill = GridBagConstraints.BOTH;
		gridBagConstraints5.weightx = 0.0D;
		gridBagConstraints5.weighty = 0.0D;
		gridBagConstraints5.gridx = 0;
		gridBagConstraints5.gridy = 3;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints4.fill = GridBagConstraints.BOTH;
		gridBagConstraints4.weightx = 1.0D;
		gridBagConstraints4.weighty = 0.0D;
		gridBagConstraints4.gridx = 1;
		gridBagConstraints4.gridy = 1;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 0.0D;
		gridBagConstraints3.weighty = 0.0D;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 1;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0D;
		gridBagConstraints2.weighty = 0.0D;
		gridBagConstraints2.gridx = 1;
		gridBagConstraints2.gridy = 0;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 0.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(500, 383));
		this.setPreferredSize(new Dimension(500, 383));
		this.setMaximumSize(new Dimension(500, 383));
		this.setMinimumSize(new Dimension(500, 383));
		this.setText("Database Details");
		this.add(getCatalogTermLabel(), gridBagConstraints1);
		this.add(getCatalogTerm(), gridBagConstraints2);
		this.add(getProcedureTermLabel(), gridBagConstraints3);
		this.add(getProcedureTerm(), gridBagConstraints4);
		this.add(getSchemaTermLabel(), gridBagConstraints5);
		this.add(getSchemaTerm(), gridBagConstraints6);
		this.add(getCatalogSeparatorLabel(), gridBagConstraints7);
		this.add(getCatalogSeparator(), gridBagConstraints8);
		this.add(getCatalogListLabel(), gridBagConstraints9);
		this.add(getCatalogListScrollPane(), gridBagConstraints10);
		this.add(getSchemaListLabel(), gridBagConstraints11);
		this.add(getSchemaListScrollPane(), gridBagConstraints12);
		this.add(getTableTypeListLabel(), gridBagConstraints13);
		this.add(getTableTypeListScrollPane(), gridBagConstraints14);
		this.add(getTypeInfoListLabel(), gridBagConstraints15);
		this.add(getTypeInfoListScrollPane(), gridBagConstraints16);
	}

	/**
	 * J^Ox_[̃x擾܂B<br>
	 * @return J^Ox_[̃x
	 */
	private ELabel getCatalogTermLabel() {
		if (catalogTermLabel == null) {
			catalogTermLabel = new ELabel();
			catalogTermLabel.setPreferredSize(new Dimension(150, 22));
			catalogTermLabel.setText("Catalog Term :");
		}
		return catalogTermLabel;
	}

	/**
	 * J^Ox_[̂擾܂B<br>
	 * @return J^Ox_[
	 */
	private ELabel getCatalogTerm() {
		if (catalogTerm == null) {
			catalogTerm = new ELabel();
			catalogTerm.setPreferredSize(new Dimension(150, 22));
		}
		return catalogTerm;
	}

	/**
	 * vV[Wx_[̃x擾܂B<br>
	 * @return vV[Wx_[̃x
	 */
	private ELabel getProcedureTermLabel() {
		if (procedureTermLabel == null) {
			procedureTermLabel = new ELabel();
			procedureTermLabel.setPreferredSize(new Dimension(150, 22));
			procedureTermLabel.setText("Procedure Term :");
		}
		return procedureTermLabel;
	}

	/**
	 * vV[Wx_[̂擾܂B<br>
	 * @return vV[Wx_[
	 */
	private ELabel getProcedureTerm() {
		if (procedureTerm == null) {
			procedureTerm = new ELabel();
			procedureTerm.setPreferredSize(new Dimension(150, 22));
		}
		return procedureTerm;
	}

	/**
	 * XL[}x_[̃x擾܂B<br>
	 * @return XL[}x_[̃x
	 */
	private ELabel getSchemaTermLabel() {
		if (schemaTermLabel == null) {
			schemaTermLabel = new ELabel();
			schemaTermLabel.setPreferredSize(new Dimension(150, 22));
			schemaTermLabel.setText("Schema Term :");
		}
		return schemaTermLabel;
	}

	/**
	 * XL[}x_[̂擾܂B<br>
	 * @return XL[}x_[
	 */
	private ELabel getSchemaTerm() {
		if (schemaTerm == null) {
			schemaTerm = new ELabel();
			schemaTerm.setPreferredSize(new Dimension(150, 22));
		}
		return schemaTerm;
	}

	/**
	 * J^OZp[^x擾܂B<br>
	 * @return J^OZp[^x
	 */
	private ELabel getCatalogSeparatorLabel() {
		if (catalogSeparatorLabel == null) {
			catalogSeparatorLabel = new ELabel();
			catalogSeparatorLabel.setPreferredSize(new Dimension(150, 22));
			catalogSeparatorLabel.setText("Catalog Separator :");
		}
		return catalogSeparatorLabel;
	}

	/**
	 * J^OZp[^擾܂B<br>
	 * @return J^OZp[^
	 */
	private ELabel getCatalogSeparator() {
		if (catalogSeparator == null) {
			catalogSeparator = new ELabel();
			catalogSeparator.setPreferredSize(new Dimension(150, 22));
		}
		return catalogSeparator;
	}

	/**
	 * J^OXgx擾܂B<br>
	 * @return J^OXgx
	 */
	private ELabel getCatalogListLabel() {
		if (catalogListLabel == null) {
			catalogListLabel = new ELabel();
			catalogListLabel.setPreferredSize(new Dimension(150, 22));
			catalogListLabel.setText("Catalog List :");
		}
		return catalogListLabel;
	}

	/**
	 * J^OXgXN[yC擾܂B<br>
	 * @return J^OXgXN[yC
	 */
	private EScrollPane getCatalogListScrollPane() {
		if (catalogListScrollPane == null) {
			catalogListScrollPane = new EScrollPane();
			catalogListScrollPane.setPreferredSize(new Dimension(240, 60));
			catalogListScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			catalogListScrollPane.setViewportView(getCatalogList());
		}
		return catalogListScrollPane;
	}

	/**
	 * J^OXg擾܂B<br>
	 * @return J^OXg
	 */
	private EList getCatalogList() {
		if (catalogList == null) {
			catalogList = new EList();
		}
		return catalogList;
	}

	/**
	 * XL[}Xgx擾܂B<br>
	 * @return XL[}Xgx
	 */
	private ELabel getSchemaListLabel() {
		if (schemaListLabel == null) {
			schemaListLabel = new ELabel();
			schemaListLabel.setPreferredSize(new Dimension(150, 22));
			schemaListLabel.setText("Schema List :");
		}
		return schemaListLabel;
	}

	/**
	 * XL[}XgXN[yC擾܂B<br>
	 * @return XL[}XgXN[yC
	 */
	private EScrollPane getSchemaListScrollPane() {
		if (schemaListScrollPane == null) {
			schemaListScrollPane = new EScrollPane();
			schemaListScrollPane.setPreferredSize(new Dimension(240, 60));
			schemaListScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			schemaListScrollPane.setViewportView(getSchemaList());
		}
		return schemaListScrollPane;
	}

	/**
	 * XL[}Xg擾܂B<br>
	 * @return XL[}Xg
	 */
	private EList getSchemaList() {
		if (schemaList == null) {
			schemaList = new EList();
		}
		return schemaList;
	}

	/**
	 * e[u^CvXgx擾܂B<br>
	 * @return e[u^CvXgx
	 */
	private ELabel getTableTypeListLabel() {
		if (tableTypeListLabel == null) {
			tableTypeListLabel = new ELabel();
			tableTypeListLabel.setPreferredSize(new Dimension(150, 22));
			tableTypeListLabel.setText("Table Type List :");
		}
		return tableTypeListLabel;
	}

	/**
	 * e[u^CvXgXN[yC擾܂B<br>
	 * @return e[u^CvXgXN[yC
	 */
	private EScrollPane getTableTypeListScrollPane() {
		if (tableTypeListScrollPane == null) {
			tableTypeListScrollPane = new EScrollPane();
			tableTypeListScrollPane.setPreferredSize(new Dimension(240, 60));
			tableTypeListScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			tableTypeListScrollPane.setViewportView(getTableTypeList());
		}
		return tableTypeListScrollPane;
	}

	/**
	 * e[u^CvXg擾܂B<br>
	 * @return e[u^CvXg
	 */
	private EList getTableTypeList() {
		if (tableTypeList == null) {
			tableTypeList = new EList();
		}
		return tableTypeList;
	}

	/**
	 * ^Cv񃊃Xgx擾܂B<br>
	 * @return ^Cv񃊃Xgx
	 */
	private ELabel getTypeInfoListLabel() {
		if (typeInfoListLabel == null) {
			typeInfoListLabel = new ELabel();
			typeInfoListLabel.setPreferredSize(new Dimension(150, 22));
			typeInfoListLabel.setText("Type Info List :");
		}
		return typeInfoListLabel;
	}

	/**
	 * ^Cv񃊃XgXN[yC擾܂B<br>
	 * @return ^Cv񃊃XgXN[yC
	 */
	private EScrollPane getTypeInfoListScrollPane() {
		if (typeInfoListScrollPane == null) {
			typeInfoListScrollPane = new EScrollPane();
			typeInfoListScrollPane.setPreferredSize(new Dimension(240, 60));
			typeInfoListScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			typeInfoListScrollPane.setViewportView(getTypeInfoList());
		}
		return typeInfoListScrollPane;
	}

	/**
	 * ^Cv񃊃Xg擾܂B<br>
	 * @return ^Cv񃊃Xg
	 */
	private EList getTypeInfoList() {
		if (typeInfoList == null) {
			typeInfoList = new EList();
		}
		return typeInfoList;
	}
}
