package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;

import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.dbbrowser.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DatabaseBrowserEBhER|[lgNG}l[WݒێNX<br>
 * <br>
 * NXSerializableC^tF[XAi\ȃtB[ĥ݂ێ܂B<br>
 * OIɉis\ȃtB[hێꍇ́A͕ۑɑΏۂƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/25	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserWindowComponentQueryManageConfig implements Serializable {

	/** m[h */
	public static final String NODE_NAME = "queryManage";

	/** e[uc[yCP[V */
	private int tableTreePaneDivideLocation;

	/** NGGAP[V */
	private int queryAreaDivideLocation;

	/** sʃGAP[V */
	private int resultAreaDivideLocation;

	/**
	 * RXgN^<br>
	 */
	DatabaseBrowserWindowComponentQueryManageConfig() {
		super();
		initialize();
	}

	/**
	 * RXgN^<br>
	 * @param root [gm[h
	 */
	DatabaseBrowserWindowComponentQueryManageConfig(Node root) {
		super();
		initialize();
		load(root);
	}

	/**
	 * ێ܂B<br>
	 */
	private void initialize() {
		tableTreePaneDivideLocation = 160;
		queryAreaDivideLocation = 80;
		resultAreaDivideLocation = -1;
	}

	/**
	 * w肳ꂽhLg̃[gGgɑ΂Ďgێm[hۑ܂B<br>
	 * @param document DocumentIuWFNg
	 * @param root [gm[h
	 */
	void save(Document document, Node root) {
		Node node = root.appendChild(document.createElement(NODE_NAME));

		Node tableTreePaneDivideLocation = node.appendChild(document.createElement("tableTreePaneDivideLocation"));
		tableTreePaneDivideLocation.appendChild(document.createTextNode(StringUtil.valueOf(getTableTreePaneDivideLocation())));

		Node queryAreaDivideLocation = node.appendChild(document.createElement("queryAreaDivideLocation"));
		queryAreaDivideLocation.appendChild(document.createTextNode(StringUtil.valueOf(getQueryAreaDivideLocation())));

		Node resultAreaDivideLocation = node.appendChild(document.createElement("resultAreaDivideLocation"));
		resultAreaDivideLocation.appendChild(document.createTextNode(StringUtil.valueOf(getResultAreaDivideLocation())));
	}

	/**
	 * w肳ꂽm[hǂݍݎg̃tB[hɔf܂B<br>
	 * @param root [gm[h
	 */
	void load(Node root) {
		NodeList nodeList = root.getChildNodes();

		initialize();

		for (int i = 0; i <= nodeList.getLength() - 1; i++) {
			Node node = nodeList.item(i);
			if ("tableTreePaneDivideLocation".equals(node.getNodeName())) {
				tableTreePaneDivideLocation = StringUtil.parsePrimitiveInt(XMLUtil.getTextContent(node));
			}
			if ("queryAreaDivideLocation".equals(node.getNodeName())) {
				queryAreaDivideLocation = StringUtil.parsePrimitiveInt(XMLUtil.getTextContent(node));
			}
			if ("resultAreaDivideLocation".equals(node.getNodeName())) {
				resultAreaDivideLocation = StringUtil.parsePrimitiveInt(XMLUtil.getTextContent(node));
			}
		}
	}

	/**
	 * e[uc[yCP[V擾܂B<br>
	 * @return e[uc[yCP[V
	 */
	public int getTableTreePaneDivideLocation() {
		return tableTreePaneDivideLocation;
	}

	/**
	 * e[uc[yCP[Vݒ肵܂B<br>
	 * @param tableTreePaneDivideLocation e[uc[yCP[V
	 */
	public void setTableTreePaneDivideLocation(int tableTreePaneDivideLocation) {
		this.tableTreePaneDivideLocation = tableTreePaneDivideLocation;
	}

	/**
	 * NGGAP[V擾܂B<br>
	 * @return NGGAP[V
	 */
	public int getQueryAreaDivideLocation() {
		return queryAreaDivideLocation;
	}

	/**
	 * NGGAP[Vݒ肵܂B<br>
	 * @param queryAreaDivideLocation NGGAP[V
	 */
	public void setQueryAreaDivideLocation(int queryAreaDivideLocation) {
		this.queryAreaDivideLocation = queryAreaDivideLocation;
	}

	/**
	 * sʃGAP[V擾܂B<br>
	 * @return sʃGAP[V
	 */
	public int getResultAreaDivideLocation() {
		return resultAreaDivideLocation;
	}

	/**
	 * sʃGAP[Vݒ肵܂B<br>
	 * @param resultAreaDivideLocation sʃGAP[V
	 */
	public void setResultAreaDivideLocation(int resultAreaDivideLocation) {
		this.resultAreaDivideLocation = resultAreaDivideLocation;
	}

	/**
	 * NX𕶎Ŏ擾܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("DatabaseBrowserWindowComponentConfig{");
		buffer.append("tableTreePaneDivideLocation=");
		buffer.append(getTableTreePaneDivideLocation());
		buffer.append(",");
		buffer.append("queryAreaDivideLocation=");
		buffer.append(getQueryAreaDivideLocation());
		buffer.append(",");
		buffer.append("resultAreaDivideLocation=");
		buffer.append(getResultAreaDivideLocation());
		buffer.append("}");
		return buffer.toString();
	}
}
