package org.phosphoresce.dbbrowser.config;

import java.awt.Rectangle;
import java.io.Serializable;

import javax.swing.JFrame;

import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.dbbrowser.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DatabaseBrowserEBhETCYݒێNX<br>
 * <br>
 * NXSerializableC^tF[XAi\ȃtB[ĥ݂ێ܂B<br>
 * OIɉis\ȃtB[hێꍇ́A͕ۑɑΏۂƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/08	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserWindowBoundsConfig implements Serializable {

	/** m[h */
	public static final String NODE_NAME = "windowBounds";

	/** EBhETCY */
	private Rectangle bounds;

	/** EBhEgXe[^X */
	private int extendsState;

	/**
	 * RXgN^<br>
	 */
	DatabaseBrowserWindowBoundsConfig() {
		super();
		initialize();
	}

	/**
	 * RXgN^<br>
	 * @param root [gm[h
	 */
	DatabaseBrowserWindowBoundsConfig(Node root) {
		super();
		initialize();
		load(root);
	}

	/**
	 * ێ܂B<br>
	 */
	private void initialize() {
		bounds = new Rectangle(0, 0, 800, 600);
		extendsState = JFrame.NORMAL;
	}

	/**
	 * w肳ꂽhLg̃[gGgɑ΂Ďgێm[hۑ܂B<br>
	 * @param document DocumentIuWFNg
	 * @param root [gm[h
	 */
	void save(Document document, Node root) {
		Node node = root.appendChild(document.createElement(NODE_NAME));

		Node x = node.appendChild(document.createElement("x"));
		Node y = node.appendChild(document.createElement("y"));
		Node width = node.appendChild(document.createElement("width"));
		Node height = node.appendChild(document.createElement("height"));
		Node extendsState = node.appendChild(document.createElement("extendsState"));

		x.appendChild(document.createTextNode(StringUtil.valueOf(getBounds().x)));
		y.appendChild(document.createTextNode(StringUtil.valueOf(getBounds().y)));
		width.appendChild(document.createTextNode(StringUtil.valueOf(getBounds().width)));
		height.appendChild(document.createTextNode(StringUtil.valueOf(getBounds().height)));
		extendsState.appendChild(document.createTextNode(StringUtil.valueOf(getExtendsState())));
	}

	/**
	 * w肳ꂽm[hǂݍݎg̃tB[hɔf܂B<br>
	 * @param root [gm[h
	 */
	void load(Node root) {
		NodeList nodeList = root.getChildNodes();

		initialize();

		for (int i = 0; i <= nodeList.getLength() - 1; i++) {
			Node node = nodeList.item(i);
			if ("x".equals(node.getNodeName())) {
				getBounds().x = StringUtil.parsePrimitiveInt(XMLUtil.getTextContent(node));
			} else if ("y".equals(node.getNodeName())) {
				getBounds().y = StringUtil.parsePrimitiveInt(XMLUtil.getTextContent(node));
			} else if ("width".equals(node.getNodeName())) {
				getBounds().width = StringUtil.parsePrimitiveInt(XMLUtil.getTextContent(node));
			} else if ("height".equals(node.getNodeName())) {
				getBounds().height = StringUtil.parsePrimitiveInt(XMLUtil.getTextContent(node));
			} else if ("extendsState".equals(node.getNodeName())) {
				extendsState = StringUtil.parsePrimitiveInt(XMLUtil.getTextContent(node));
			}
		}
	}

	/**
	 * EBhETCY擾܂B<br>
	 * @return EBhETCY
	 */
	public Rectangle getBounds() {
		if (bounds == null) {
			bounds = new Rectangle();
		}
		return bounds;
	}

	/**
	 * EBhETCYݒ肵܂B<br>
	 * @param bounds EBhETCY
	 */
	public void setBounds(Rectangle bounds) {
		this.bounds = bounds;
	}

	/**
	 * EBhEgXe[^X擾܂B<br>
	 * @return EBhEgXe[^X
	 */
	public int getExtendsState() {
		return extendsState;
	}

	/**
	 * EBhEgXe[^Xݒ肵܂B<br>
	 * @param extendsState EBhEgXe[^X
	 */
	public void setExtendsState(int extendsState) {
		this.extendsState = extendsState;
	}

	/**
	 * NX𕶎Ŏ擾܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("DatabaseBrowserWindowBoundsConfig{");
		buffer.append("bounds=");
		buffer.append(getBounds());
		buffer.append(",");
		buffer.append("extendsState=");
		buffer.append(getExtendsState());
		buffer.append("}");
		return buffer.toString();
	}
}
