package org.phosphoresce.dbbrowser.config;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * DatabaseBrowser`ς݃f[^x[XRlNVݒێNX<br>
 * <br>
 * NXSerializableC^tF[XAi\ȃtB[ĥ݂ێ܂B<br>
 * OIɉis\ȃtB[hێꍇ́A͕ۑɑΏۂƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/10/08	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseBrowserDefinitionedConnectionConfig implements Serializable {

	/** m[h */
	public static final String NODE_NAME = "definitionedConnection";

	/** `ς݃f[^x[Xڑݒ胊Xg */
	private List databaseConfigDefinitionList;

	/**
	 * RXgN^<br>
	 */
	DatabaseBrowserDefinitionedConnectionConfig() {
		super();
		initialize();
	}

	/**
	 * ێ܂B<br>
	 */
	private void initialize() {
		databaseConfigDefinitionList = new LinkedList();
	}

	/**
	 * w肳ꂽhLg̃[gGgɑ΂Ďgێm[hۑ܂B<br>
	 * @param document DocumentIuWFNg
	 * @param root [gm[h
	 */
	void save(Document document, Node root) {
		Node node = root.appendChild(document.createElement(NODE_NAME));

		for (Iterator iterator = getDatabaseConfigDefinitionList().iterator(); iterator.hasNext();) {
			DatabaseBrowserConnectionConfig connectionConfig = (DatabaseBrowserConnectionConfig) iterator.next();
			connectionConfig.save(document, node);
		}
	}

	/**
	 * w肳ꂽm[hǂݍݎg̃tB[hɔf܂B<br>
	 * @param root [gm[h
	 */
	void load(Node root) {
		NodeList nodeList = root.getChildNodes();

		initialize();

		for (int i = 0; i <= nodeList.getLength() - 1; i++) {
			Node node = nodeList.item(i);
			if (DatabaseBrowserConnectionConfig.NODE_NAME.equals(node.getNodeName())) {
				getDatabaseConfigDefinitionList().add(new DatabaseBrowserConnectionConfig(node));
			}
		}
	}

	/**
	 * `ς݃f[^x[Xڑݒ胊Xg擾܂B<br>
	 * @return `ς݃f[^x[Xڑݒ胊Xg
	 */
	public List getDatabaseConfigDefinitionList() {
		if (databaseConfigDefinitionList == null) {
			databaseConfigDefinitionList = new LinkedList();
		}
		return databaseConfigDefinitionList;
	}

	/**
	 * `ς݃f[^x[Xڑݒ胊Xgݒ肵܂B<br>
	 * @param databaseConfigDefinitionList `ς݃f[^x[Xڑݒ胊Xg
	 */
	public void setDatabaseConfigDefinitionList(List databaseConfigDefinitionList) {
		this.databaseConfigDefinitionList = databaseConfigDefinitionList;
	}

	/**
	 * `ς݃f[^x[Xڑݒ胊XgɕێĂw肳ꂽȌ擾܂B<br>
	 * @param name `
	 * @return f[^x[XڑIuWFNg
	 */
	public DatabaseConfig getDatabaseConfig(String name) {
		for (Iterator iterator = getDatabaseConfigDefinitionList().iterator(); iterator.hasNext();) {
			DatabaseBrowserConnectionConfig connectionConfig = (DatabaseBrowserConnectionConfig) iterator.next();
			if (name.equals(connectionConfig.getName())) {
				return connectionConfig.getDatabaseConfig();
			}
		}
		return null;
	}

	/**
	 * w肳ꂽ̂̃f[^x[Xڑݒ肪݂邩肵܂B<br>
	 * @param name `
	 * @return w肳ꂽ̂̃f[^x[Xڑݒ肪݂ꍇtruew
	 */
	public boolean containsDatabaseConfig(String name) {
		return getDatabaseConfig(name) != null;
	}

	/**
	 * w肳ꂽ̂Ńf[^x[Xڑݒ胊Xgɒ`ǉ܂B<br>
	 * @param name `
	 * @param config f[^x[XڑIuWFNg
	 */
	public void addDatabaseConfig(String name, DatabaseConfig config) {
		DatabaseBrowserConnectionConfig connectionConfig = new DatabaseBrowserConnectionConfig();
		connectionConfig.setName(name);
		connectionConfig.setDatabaseConfig(config);
		getDatabaseConfigDefinitionList().add(connectionConfig);
	}

	/**
	 * w肳ꂽ̂Ńf[^x[Xڑݒ胊Xgɒ`ݒ肵܂B<br>
	 * ɑ݂閼̂w肳ꂽꍇ͂̊ݒ肪㏑A݂Ȃꍇ͐Vɒǉ܂B<br>
	 * @param name `
	 * @param config f[^x[XڑIuWFNg
	 */
	public void setDatabaseConfig(String name, DatabaseConfig config) {
		if (!containsDatabaseConfig(name)) {
			addDatabaseConfig(name, config);
			return;
		}
		for (Iterator iterator = getDatabaseConfigDefinitionList().iterator(); iterator.hasNext();) {
			DatabaseBrowserConnectionConfig connectionConfig = (DatabaseBrowserConnectionConfig) iterator.next();
			if (name.equals(connectionConfig.getName())) {
				connectionConfig.setName(name);
				connectionConfig.setDatabaseConfig(config);
			}
		}
	}

	/**
	 * NX𕶎Ŏ擾܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("DatabaseBrowserDefinitionedConnectionConfig{");
		buffer.append("databaseConfigDefinitionList=");
		buffer.append(getDatabaseConfigDefinitionList());
		buffer.append("}");
		return buffer.toString();
	}
}
