/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;

public abstract class PatternValidator {
    private LinkedList _patterns = new LinkedList();
    private boolean _nillable = false;
    private RegExpEvaluator _regex = null;

    public PatternValidator() {
    }

    public PatternValidator(String pattern) {
        this._patterns.add(pattern);
    }

    public String getPattern() {
        return this._patterns.isEmpty() ? null : (String)this._patterns.getFirst();
    }

    public List getPatterns() {
        return Collections.unmodifiableList(this._patterns);
    }

    public boolean isNillable() {
        return this._nillable;
    }

    public boolean hasPattern() {
        return !this._patterns.isEmpty();
    }

    public void setNillable(boolean nillable) {
        this._nillable = nillable;
    }

    public void setPattern(String pattern) {
        this.clearPatterns();
        this.addPattern(pattern);
    }

    public void addPattern(String pattern) {
        this._patterns.add(pattern);
    }

    public void clearPatterns() {
        this._patterns.clear();
    }

    public void validate(String str, ValidationContext context) throws ValidationException {
        if (this._patterns.isEmpty()) {
            return;
        }
        if (context == null) {
            throw new IllegalArgumentException("PatternValidator given a null context");
        }
        if (this._regex == null) {
            this.initEvaluator(context);
        }
        Iterator i = this._patterns.iterator();
        while (i.hasNext()) {
            String pattern = (String)i.next();
            this._regex.setExpression(pattern);
            if (!this._regex.matches(str)) continue;
            return;
        }
        StringBuffer buff = new StringBuffer(str);
        if (this._patterns.size() == 1) {
            buff.append("does not match the required regular expression: ");
            buff.append("\"");
            buff.append(this._patterns.getFirst());
            buff.append("\"");
        } else {
            buff.append("does not match any of the following regular expressions: ");
            Iterator i2 = this._patterns.iterator();
            while (i2.hasNext()) {
                buff.append("\"");
                buff.append((String)i2.next());
                buff.append("\"");
                if (!i2.hasNext()) continue;
                buff.append(", ");
            }
        }
        throw new ValidationException(buff.toString());
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            if (!this._nillable) {
                String err = "PatternValidator cannot validate a null object.";
                throw new ValidationException(err);
            }
            return;
        }
        this.validate(object.toString(), context);
    }

    private void initEvaluator(ValidationContext context) {
        this._regex = context.getInternalContext().getRegExpEvaluator();
        if (this._regex == null) {
            this._regex = new DefaultRegExpEvaluator();
        }
    }

    class DefaultRegExpEvaluator
    implements RegExpEvaluator {
        DefaultRegExpEvaluator() {
        }

        public void setExpression(String rexpr) {
        }

        public boolean matches(String value) {
            return false;
        }
    }
}

