/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.repo.RepositoryUtil;

public class SimpleFontFace
implements FontFace {
    private String file;
    private Font font;

    public static SimpleFontFace getInstance(JasperReportsContext jasperReportsContext, String fontName) {
        SimpleFontFace fontFace = null;
        if (fontName != null) {
            if (fontName.trim().toUpperCase().endsWith(".TTF")) {
                fontFace = new SimpleFontFace(fontName);
            } else {
                JRFontUtil.checkAwtFont(fontName, JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font"));
                fontFace = new SimpleFontFace(new Font(fontName, 0, JRPropertiesUtil.getInstance(jasperReportsContext).getIntegerProperty("net.sf.jasperreports.default.font.size")));
            }
        }
        return fontFace;
    }

    public SimpleFontFace(JasperReportsContext jasperReportsContext, String file) {
        this.file = file;
        InputStream is = null;
        try {
            is = RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(file);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        try {
            this.font = Font.createFont(0, is);
        }
        catch (FontFormatException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public SimpleFontFace(String file) {
        this(DefaultJasperReportsContext.getInstance(), file);
    }

    public SimpleFontFace(Font font) {
        this.font = font;
    }

    @Override
    public String getName() {
        return this.font.getName();
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public Font getFont() {
        return this.font;
    }
}

