/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class XlsxDrawingRelsHelper
extends BaseHelper {
    private Map<String, Integer> linkCache = new HashMap<String, Integer>();
    private Set<String> imageNames = new HashSet<String>();

    public XlsxDrawingRelsHelper(Writer writer) {
        super(writer);
    }

    public void exportHeader() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        this.write("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n");
    }

    public void exportImage(String imageName) {
        if (!this.imageNames.contains(imageName)) {
            this.write(" <Relationship Id=\"" + imageName + "\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image\" Target=\"../media/" + imageName + "\"/>\n");
            this.imageNames.add(imageName);
        }
    }

    public int getHyperlink(String href) {
        Integer linkIndex = this.linkCache.get(href);
        if (linkIndex == null) {
            linkIndex = this.linkCache.size();
            this.exportHyperlink(linkIndex, href);
            this.linkCache.put(href, linkIndex);
        }
        return linkIndex;
    }

    private void exportHyperlink(int index, String href) {
        this.write(" <Relationship Id=\"rIdLnk" + index + "\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink\" Target=\"" + JRStringUtil.xmlEncode(href) + "\" TargetMode=\"External\"/>\n");
    }

    public void exportFooter() {
        this.write("</Relationships>\n");
    }
}

