/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRDesignTextField
extends JRDesignTextElement
implements JRTextField {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EXPRESSION = "expression";
    public static final String PROPERTY_PATTERN_EXPRESSION = "patternExpression";
    protected boolean isStretchWithOverflow;
    protected EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    protected String pattern;
    protected Boolean isBlankWhenNull;
    protected String linkType;
    protected String linkTarget;
    private List<JRHyperlinkParameter> hyperlinkParameters = new ArrayList<JRHyperlinkParameter>();
    protected JRGroup evaluationGroup;
    protected JRExpression expression;
    protected JRExpression patternExpression;
    protected JRExpression anchorNameExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 40600;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private byte evaluationTime;

    public JRDesignTextField() {
        super(null);
    }

    public JRDesignTextField(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public boolean isStretchWithOverflow() {
        return this.isStretchWithOverflow;
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    @Override
    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    @Override
    public String getOwnPattern() {
        return this.pattern;
    }

    @Override
    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    @Override
    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getPatternExpression() {
        return this.patternExpression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void setStretchWithOverflow(boolean isStretch) {
        boolean old = this.isStretchWithOverflow;
        this.isStretchWithOverflow = isStretch;
        this.getEventSupport().firePropertyChange("stretchWithOverflow", old, this.isStretchWithOverflow);
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTimeValue) {
        EvaluationTimeEnum old = this.evaluationTimeValue;
        this.evaluationTimeValue = evaluationTimeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTimeValue);
    }

    @Override
    public void setPattern(String pattern) {
        String old = this.pattern;
        this.pattern = pattern;
        this.getEventSupport().firePropertyChange("pattern", old, this.pattern);
    }

    @Override
    public void setBlankWhenNull(boolean isBlank) {
        this.setBlankWhenNull(isBlank ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBlankWhenNull(Boolean isBlank) {
        Boolean old = this.isBlankWhenNull;
        this.isBlankWhenNull = isBlank;
        this.getEventSupport().firePropertyChange("blankWhenNull", old, this.isBlankWhenNull);
    }

    public void setHyperlinkType(byte hyperlinkType) {
        this.setHyperlinkType(HyperlinkTypeEnum.getByValue(hyperlinkType));
    }

    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public void setHyperlinkTarget(byte hyperlinkTarget) {
        this.setHyperlinkTarget(HyperlinkTargetEnum.getByValue(hyperlinkTarget));
    }

    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    public void setEvaluationGroup(JRGroup evaluationGroup) {
        JRGroup old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    public void setExpression(JRExpression expression) {
        JRExpression old = this.expression;
        this.expression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_EXPRESSION, old, this.expression);
    }

    public void setPatternExpression(JRExpression patternExpression) {
        JRExpression old = this.patternExpression;
        this.patternExpression = patternExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_PATTERN_EXPRESSION, old, this.patternExpression);
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        JRExpression old = this.anchorNameExpression;
        this.anchorNameExpression = anchorNameExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, old, this.anchorNameExpression);
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", old, this.hyperlinkReferenceExpression);
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", old, this.hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", old, this.hyperlinkPageExpression);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitTextField(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        int old = this.bookmarkLevel;
        this.bookmarkLevel = bookmarkLevel;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, old, this.bookmarkLevel);
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String type) {
        String old = this.linkType;
        this.linkType = type;
        this.getEventSupport().firePropertyChange("linkType", old, this.linkType);
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String target) {
        String old = this.linkTarget;
        this.linkTarget = target;
        this.getEventSupport().firePropertyChange("linkTarget", old, this.linkTarget);
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    public List<JRHyperlinkParameter> getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", parameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParameters.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator<JRHyperlinkParameter> it = this.hyperlinkParameters.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, it.nextIndex());
        }
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", old, this.hyperlinkTooltipExpression);
    }

    @Override
    public Object clone() {
        JRDesignTextField clone = (JRDesignTextField)super.clone();
        clone.hyperlinkParameters = JRCloneUtils.cloneList(this.hyperlinkParameters);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.patternExpression = JRCloneUtils.nullSafeClone(this.patternExpression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
        }
    }
}

