/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class StringUtil {
    public static final String EMPTY = "";
    private static final String[] hexStrings = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final char[] SIGNS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '=', '~', '|', '`', '{', '+', '*', '}', '<', '>', '?', '_', '-', '^', '\\', '@', '[', ';', ':', ']', ',', '.', '/'};
    public static final String NEWLINE_CODE_CRLF = new String(new byte[]{13, 10});
    public static final String NEWLINE_CODE_CR = new String(new byte[]{13});
    public static final String NEWLINE_CODE_LF = new String(new byte[]{10});
    public static final String DEFAULT_JAVA_CHARSET = "MS932";
    public static final String DEFAULT_OUTPUTFILE_CHARSET = "8859_1";

    private StringUtil() {
    }

    public static boolean isEmpty(String source) {
        return source == null || EMPTY.equals(source);
    }

    public static boolean isAscii(String value) {
        return value.length() == value.getBytes().length;
    }

    public static boolean isDigit(String source) {
        try {
            Double.valueOf(source);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNumeric(String source) {
        if (StringUtil.isEmpty(source)) {
            return true;
        }
        for (int i = 0; i <= source.length() - 1; ++i) {
            char c = source.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String source, char[] exclude) {
        if (StringUtil.isEmpty(source)) {
            return true;
        }
        for (int i = 0; i <= source.length() - 1; ++i) {
            char c = source.charAt(i);
            if (c >= '0' && c <= '9') continue;
            boolean skip = false;
            for (int j = 0; j <= exclude.length - 1; ++j) {
                if (c != exclude[j]) continue;
                skip = true;
            }
            if (skip) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphabet(String source) {
        if (StringUtil.isEmpty(source)) {
            return true;
        }
        for (int i = 0; i <= source.length() - 1; ++i) {
            char c = source.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String source) {
        if (StringUtil.isEmpty(source)) {
            return true;
        }
        for (int i = 0; i <= source.length() - 1; ++i) {
            char c = source.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String source, char[] exclude) {
        if (StringUtil.isEmpty(source)) {
            return true;
        }
        for (int i = 0; i <= source.length() - 1; ++i) {
            char c = source.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            boolean skip = false;
            for (int j = 0; j <= exclude.length - 1; ++j) {
                if (c != exclude[j]) continue;
                skip = true;
            }
            if (skip) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return true;
        }
        if (value1 != null) {
            return value1.equals(value2);
        }
        return value2.equals(value1);
    }

    public static boolean equalsIgnoreCase(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return true;
        }
        if (value1 != null) {
            return value1.equalsIgnoreCase(value2);
        }
        return value2.equalsIgnoreCase(value1);
    }

    public static boolean contains(String[] compares, String value) {
        if (compares == null) {
            return false;
        }
        for (int i = 0; i <= compares.length - 1; ++i) {
            String compare = compares[i];
            boolean result = StringUtil.equals(compare, value);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] compares, String value) {
        if (compares == null) {
            return false;
        }
        for (int i = 0; i <= compares.length - 1; ++i) {
            String compare = compares[i];
            boolean result = StringUtil.equalsIgnoreCase(compare, value);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public static int length(String source) {
        return source == null ? 0 : source.length();
    }

    public static boolean isInLenghtByte(String source, int byteLength) {
        if (StringUtil.isEmpty(source)) {
            return true;
        }
        return source.getBytes().length <= byteLength;
    }

    public static boolean isInLenghtByte(String source, int byteLength, String encode) {
        if (StringUtil.isEmpty(source)) {
            return true;
        }
        try {
            return source.getBytes(encode).length <= byteLength;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u6b63\u306a\u30a8\u30f3\u30b3\u30fc\u30c9\u65b9\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f", e);
        }
    }

    public static boolean isInLength(String source, int length) {
        if (StringUtil.isEmpty(source)) {
            return true;
        }
        return source.length() <= length;
    }

    public static boolean isAscii(char c) {
        return StringUtil.isInLenghtByte(String.valueOf(c), 1);
    }

    public static String left(String source, int length) {
        if (length <= 0) {
            return EMPTY;
        }
        if (StringUtil.isEmpty(source) || source.length() <= length) {
            return source;
        }
        return source.substring(0, length);
    }

    public static String leftb(String source, int length) {
        if (length <= 0) {
            return EMPTY;
        }
        if (StringUtil.isEmpty(source) || StringUtil.isInLenghtByte(source, length)) {
            return source;
        }
        return StringUtil.substrb(source, length);
    }

    public static String leftb(String source, int length, String encode) {
        if (length <= 0) {
            return EMPTY;
        }
        if (StringUtil.isEmpty(source) || StringUtil.isInLenghtByte(source, length, encode)) {
            return source;
        }
        return StringUtil.substrb(source, length, encode);
    }

    public static String right(String source, int length) {
        if (length <= 0) {
            return EMPTY;
        }
        if (StringUtil.isEmpty(source) || source.length() <= length) {
            return source;
        }
        return source.substring(source.length() - length);
    }

    public static String rightb(String source, int length) {
        if (length <= 0) {
            return EMPTY;
        }
        if (StringUtil.isEmpty(source) || StringUtil.isInLenghtByte(source, length)) {
            return source;
        }
        return StringUtil.substrb(source, length);
    }

    public static String rightb(String source, int length, String encode) {
        if (length <= 0) {
            return EMPTY;
        }
        if (StringUtil.isEmpty(source) || StringUtil.isInLenghtByte(source, length, encode)) {
            return source;
        }
        return StringUtil.substrb(source, length, encode);
    }

    public static String mid(String source, int start, int end) {
        if (end - start < 0) {
            return EMPTY;
        }
        if (StringUtil.isEmpty(source)) {
            return source;
        }
        if (source.length() - 1 <= start) {
            return EMPTY;
        }
        String buffer = StringUtil.right(source, source.length() - start);
        return StringUtil.left(buffer, end - start + 1);
    }

    public static String midb(String source, int start, int end) {
        if (end - start < 0) {
            return EMPTY;
        }
        if (StringUtil.isEmpty(source)) {
            return source;
        }
        if (StringUtil.lenb(source) - 1 <= start) {
            return EMPTY;
        }
        String buffer = StringUtil.rightb(source, StringUtil.lenb(source) - start);
        return StringUtil.leftb(buffer, end - start + 1);
    }

    public static String midb(String source, int start, int end, String encode) {
        if (end - start < 0) {
            return EMPTY;
        }
        if (StringUtil.isEmpty(source)) {
            return source;
        }
        if (StringUtil.lenb(source, encode) - 1 <= start) {
            return EMPTY;
        }
        String buffer = StringUtil.rightb(source, StringUtil.lenb(source, encode) - start, encode);
        return StringUtil.leftb(buffer, end - start + 1, encode);
    }

    public static int len(String source) {
        return StringUtil.isEmpty(source) ? 0 : source.length();
    }

    public static int lenb(String source) {
        return StringUtil.isEmpty(source) ? 0 : source.getBytes().length;
    }

    public static int lenb(String source, String encode) {
        try {
            return StringUtil.isEmpty(source) ? 0 : source.getBytes(encode).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u6b63\u306a\u30a8\u30f3\u30b3\u30fc\u30c9\u65b9\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f", e);
        }
    }

    public static String replace(String source, String before, String after) {
        if (StringUtil.isEmpty(source) || source.indexOf(before) == -1) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        int index = source.indexOf(before);
        buffer.append(source.substring(0, index) + after);
        if (index + before.length() < source.length()) {
            String rest = source.substring(index + before.length(), source.length());
            buffer.append(StringUtil.replace(rest, before, after));
        }
        return buffer.toString();
    }

    public static String reverse(String source) {
        return new StringBuffer(source).reverse().toString();
    }

    public static int countChar(String source, char ch) {
        if (StringUtil.isEmpty(source)) {
            return 0;
        }
        int counter = 0;
        for (int i = 0; i <= source.length() - 1; ++i) {
            if (source.charAt(i) != ch) continue;
            ++counter;
        }
        return counter;
    }

    public static boolean isValidityEncode(String encode) {
        String value = "foo";
        try {
            value.getBytes(encode);
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        return true;
    }

    public static String substrb(String value, int lenb, String encode) {
        if (lenb <= 0) {
            return EMPTY;
        }
        try {
            while (value.getBytes(encode).length > lenb) {
                value = value.substring(0, value.length() - 1);
            }
            while (value.getBytes(encode).length < lenb) {
                value = value + " ";
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u6b63\u306a\u30a8\u30f3\u30b3\u30fc\u30c9\u65b9\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f", e);
        }
        return value;
    }

    public static String substrb(String value, int lenb) {
        if (lenb <= 0) {
            return EMPTY;
        }
        while (value.getBytes().length > lenb) {
            value = value.substring(0, value.length() - 1);
        }
        while (value.getBytes().length < lenb) {
            value = value + " ";
        }
        return value;
    }

    public static String supplementByteWithChar(String value, int lenb, String encode, char c, boolean isHeadSupplement) {
        if (lenb <= 0) {
            return EMPTY;
        }
        StringBuffer buffer = new StringBuffer(value);
        try {
            while (buffer.toString().getBytes(encode).length < lenb) {
                if (isHeadSupplement) {
                    buffer.insert(0, c);
                    continue;
                }
                buffer.append(c);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u6b63\u306a\u30a8\u30f3\u30b3\u30fc\u30c9\u65b9\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f", e);
        }
        return StringUtil.substrb(buffer.toString(), lenb, encode);
    }

    public static String supplementByteWithChar(String value, int lenb, char c, boolean isHeadSupplement) {
        if (lenb <= 0) {
            return EMPTY;
        }
        StringBuffer buffer = new StringBuffer(value);
        while (buffer.toString().getBytes().length < lenb) {
            if (isHeadSupplement) {
                buffer.insert(0, c);
                continue;
            }
            buffer.append(c);
        }
        return StringUtil.substrb(buffer.toString(), lenb);
    }

    public static String supplementByteWithSpaceHead(String value, int lenb, String encode) {
        return StringUtil.supplementByteWithChar(value, lenb, encode, ' ', true);
    }

    public static String supplementByteWithSpaceHead(String value, int lenb) {
        return StringUtil.supplementByteWithChar(value, lenb, ' ', true);
    }

    public static String supplementByteWithSpaceFoot(String value, int lenb, String encode) {
        return StringUtil.supplementByteWithChar(value, lenb, encode, ' ', false);
    }

    public static String supplementByteWithSpaceFoot(String value, int lenb) {
        return StringUtil.supplementByteWithChar(value, lenb, ' ', false);
    }

    public static String supplementByteWithZeroHead(String value, int lenb, String encode) {
        return StringUtil.supplementByteWithChar(value, lenb, encode, '0', true);
    }

    public static String supplementByteWithZeroHead(String value, int lenb) {
        return StringUtil.supplementByteWithChar(value, lenb, '0', true);
    }

    public static String supplementByteWithZeroFoot(String value, int lenb, String encode) {
        return StringUtil.supplementByteWithChar(value, lenb, encode, '0', false);
    }

    public static String supplementByteWithZeroFoot(String value, int lenb) {
        return StringUtil.supplementByteWithChar(value, lenb, '0', false);
    }

    public static String encode(String value, String charset) {
        if (value == null) {
            return null;
        }
        try {
            return new String(value.getBytes(DEFAULT_JAVA_CHARSET), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u4e0d\u6b63\u306a\u30a8\u30f3\u30b3\u30fc\u30c9\u65b9\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f", e);
        }
    }

    public static String valueOf(Object value) {
        if (value == null) {
            return EMPTY;
        }
        return String.valueOf(value);
    }

    public static String valueOf(boolean value) {
        return String.valueOf(value);
    }

    public static String valueOf(char value) {
        return String.valueOf(value);
    }

    public static String valueOf(char[] value) {
        return String.valueOf(value);
    }

    public static String valueOf(char[] value, int offset, int count) {
        return String.valueOf(value, offset, count);
    }

    public static String valueOf(double value) {
        return String.valueOf(value);
    }

    public static String valueOf(float value) {
        return String.valueOf(value);
    }

    public static String valueOf(int value) {
        return String.valueOf(value);
    }

    public static String valueOf(long value) {
        return String.valueOf(value);
    }

    public static Long parseLong(String value) {
        return StringUtil.isEmpty(value) ? null : Long.valueOf(value);
    }

    public static Integer parseInteger(String value) {
        return StringUtil.isEmpty(value) ? null : Integer.valueOf(value);
    }

    public static BigDecimal parseBigDecimal(String value) {
        return StringUtil.isEmpty(value) ? null : BigDecimal.valueOf(Long.parseLong(value));
    }

    public static int parsePrimitiveInt(String value) {
        return StringUtil.isEmpty(value) ? 0 : Integer.parseInt(value);
    }

    public static long parsePrimitiveLong(String value) {
        return StringUtil.isEmpty(value) ? 0L : Long.parseLong(value);
    }

    public static String formatZeroFix(int value, int length) {
        if (value < 0 || length < 0) {
            throw new RuntimeException("\u6570\u5024\u307e\u305f\u306f\u88dc\u6b63\u6841\u6570\u306b\u8ca0\u6570\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        StringBuffer buffer = new StringBuffer(length);
        String number = String.valueOf(value);
        for (int i = 0; i < length - number.length(); ++i) {
            buffer.append("0");
        }
        buffer.append(number);
        return buffer.toString();
    }

    public static String formatZeroFix(long value, int length) {
        if (value < 0L || length < 0) {
            throw new RuntimeException("\u6570\u5024\u307e\u305f\u306f\u88dc\u6b63\u6841\u6570\u306b\u8ca0\u6570\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        StringBuffer buffer = new StringBuffer(length);
        String number = String.valueOf(value);
        for (int i = 0; i < length - number.length(); ++i) {
            buffer.append("0");
        }
        buffer.append(number);
        return buffer.toString();
    }

    public static String formatComma(long value) {
        return StringUtil.formatComma(new BigDecimal(EMPTY + value));
    }

    public static String formatComma(int value) {
        return StringUtil.formatComma(new BigDecimal(EMPTY + value));
    }

    public static String formatComma(BigDecimal value) {
        if (value == null) {
            return EMPTY;
        }
        StringBuffer render = new StringBuffer();
        String buffer = value.toString();
        for (int i = 0; i <= buffer.length() - 1; ++i) {
            render.insert(0, buffer.charAt(buffer.length() - 1 - i));
            if ((i + 1) % 3 != 0) continue;
            render.insert(0, ',');
        }
        if (render.charAt(0) == ',') {
            render.delete(0, 1);
        }
        return render.toString();
    }

    public static String formatCurrency(BigDecimal value) {
        if (value == null) {
            return EMPTY;
        }
        StringBuffer render = new StringBuffer();
        String buffer = value.toString();
        for (int i = 0; i <= buffer.length() - 1; ++i) {
            render.insert(0, buffer.charAt(buffer.length() - 1 - i));
            if ((i + 1) % 3 != 0) continue;
            render.insert(0, ',');
        }
        if (render.charAt(0) == ',') {
            render.delete(0, 1);
        }
        render.insert(0, '\\');
        return render.toString();
    }

    public static BigDecimal parseCurrency(String value) {
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        String buffer = value;
        buffer = StringUtil.replace(buffer, ",", EMPTY);
        buffer = StringUtil.replace(buffer, "\\", EMPTY);
        return new BigDecimal(buffer);
    }

    public static String formatPercent(Double value, int point) {
        if (value == null) {
            return EMPTY;
        }
        String buffer = StringUtil.valueOf(value * 100.0);
        buffer = buffer.indexOf("0") > 0 ? buffer + "00" : buffer + ".00";
        return point == 0 ? buffer.substring(0, buffer.indexOf(".")) : buffer.substring(0, buffer.indexOf(".") + point + 1) + "%";
    }

    public static String formatPassword(String value) {
        if (StringUtil.isEmpty(value)) {
            return EMPTY;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i <= value.getBytes().length - 1; ++i) {
            result.append("*");
        }
        return result.toString();
    }

    public static String escapeFilename(String value, String replace) {
        if (StringUtil.isEmpty(value)) {
            return EMPTY;
        }
        value = StringUtil.replace(value, "\\", replace);
        value = StringUtil.replace(value, "/", replace);
        value = StringUtil.replace(value, ":", replace);
        value = StringUtil.replace(value, "*", replace);
        value = StringUtil.replace(value, "?", replace);
        value = StringUtil.replace(value, "\"", replace);
        value = StringUtil.replace(value, "<", replace);
        value = StringUtil.replace(value, ">", replace);
        value = StringUtil.replace(value, "|", replace);
        return value;
    }

    public static String bundleDecorate(String source, String deco) {
        return new StringBuffer(source).append(deco).insert(0, deco).toString();
    }

    public static String bind(String source, String[] params) {
        if (params == null || params.length == 0 || source == null || source.length() == 0) {
            return source;
        }
        String render = source;
        for (int i = 0; i <= params.length - 1; ++i) {
            render = StringUtil.replace(render, "{" + i + "}", params[i] == null ? EMPTY : params[i]);
        }
        return render;
    }

    public static String nullsafe(String value) {
        return value == null ? EMPTY : value;
    }

    public static String native2ascii(String value) {
        char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String SPECIAL_SAVE_CHARS = "=: \t\r\n\f#!";
        int length = value.length();
        StringBuffer outBuffer = new StringBuffer(length * 2);
        block8: for (int x = 0; x < length; ++x) {
            char c = value.charAt(x);
            switch (c) {
                case ' ': {
                    outBuffer.append('\\');
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(HEX_DIGIT[c >> 12 & 0xF & 0xF]);
                        outBuffer.append(HEX_DIGIT[c >> 8 & 0xF & 0xF]);
                        outBuffer.append(HEX_DIGIT[c >> 4 & 0xF & 0xF]);
                        outBuffer.append(HEX_DIGIT[c & 0xF & 0xF]);
                        continue block8;
                    }
                    if ("=: \t\r\n\f#!".indexOf(c) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(c);
                }
            }
        }
        return outBuffer.toString();
    }

    public static String ascii2native(String value) {
        int length = value.length();
        StringBuffer buffer = new StringBuffer(length);
        int x = 0;
        while (x < length) {
            int c;
            if ((c = value.charAt(x++)) == 92) {
                if ((c = value.charAt(x++)) == 117) {
                    int ci = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        c = value.charAt(x++);
                        switch (c) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                ci = (ci << 4) + c - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                ci = (ci << 4) + 10 + c - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                ci = (ci << 4) + 10 + c - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    buffer.append((char)ci);
                    continue;
                }
                if (c == 116) {
                    c = 9;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                }
                buffer.append((char)c);
                continue;
            }
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    public static String toHex(byte b) {
        int lbs = b & 0xF;
        int sbs = (b & 0xF0) >> 4;
        return hexStrings[sbs] + hexStrings[lbs];
    }

    public static String toHex(byte[] b) {
        String result = EMPTY;
        for (int i = 0; i < b.length; ++i) {
            result = result + StringUtil.toHex(b[i]);
        }
        return result;
    }

    public static String toMD5Hash(String value) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        md.update(value == null ? EMPTY.getBytes() : value.getBytes());
        return StringUtil.toHex(md.digest());
    }

    public static String toHTML(String value) {
        String buffer = value;
        buffer = StringUtil.replace(buffer, "\n", "<br>");
        buffer = StringUtil.replace(buffer, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        buffer = StringUtil.replace(buffer, " ", "&nbsp;");
        return buffer;
    }
}

