/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.phosphoresce.commons.util.ByteFIFOStack;

public final class StreamUtil {
    public static final String DEFAULT_LINE_SEPARATOR = "\r\n";
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 2048;

    private StreamUtil() {
    }

    public static String getStringValue(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuffer buffer = new StringBuffer();
        while (reader.ready()) {
            buffer.append(reader.readLine());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static byte[] reads(InputStream stream, int length) throws IOException {
        int readsize;
        byte[] data;
        int readedsize;
        if (length <= 0) {
            return new byte[0];
        }
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        int total = 0;
        while ((readedsize = stream.read(data = new byte[readsize = length < total + 2048 ? length - total : 2048])) != -1) {
            byteOutputStream.write(data, 0, readedsize);
            if ((total += readedsize) < length) continue;
            break;
        }
        return byteOutputStream.toByteArray();
    }

    public static String readLine(InputStream stream, String separator) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        ByteFIFOStack stack = new ByteFIFOStack(separator.length());
        int b = -1;
        while ((b = stream.read()) != -1) {
            byte[] data = stack.push(b);
            byteOutputStream.write(data);
            if (!separator.equals(new String(stack.getBytes()))) continue;
            break;
        }
        String value = new String(byteOutputStream.toByteArray());
        return value;
    }

    public static String readLine(InputStream stream) throws IOException {
        return StreamUtil.readLine(stream, DEFAULT_LINE_SEPARATOR);
    }

    public static void writes(OutputStream stream, byte[] bytes) throws IOException {
        stream.write(bytes);
    }

    public static void writeLine(OutputStream stream, String value, String separator) throws IOException {
        stream.write(value.getBytes());
        stream.write(separator.getBytes());
    }

    public static void writeLine(OutputStream stream, String value) throws IOException {
        StreamUtil.writeLine(stream, value, DEFAULT_LINE_SEPARATOR);
    }

    public static void writeLine(OutputStream stream) throws IOException {
        StreamUtil.writeLine(stream, "", DEFAULT_LINE_SEPARATOR);
    }
}

