/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.util;

import java.io.PrintStream;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static void printByteTrace(byte[] bytes, PrintStream stream) {
        if (bytes == null) {
            stream.println("Bytes is null");
        } else {
            int length = bytes.length;
            stream.println("Byte Length : " + length);
            if (length == 0) {
                return;
            }
            for (int r = 0; r <= length / 16 && r * 16 != length; ++r) {
                StringBuffer line = new StringBuffer();
                String row = Integer.toHexString(r * 16);
                while (row.length() < 8) {
                    row = "0" + row;
                }
                line.append(row);
                line.append(": ");
                byte[] buffer = new byte[16];
                int i = r * 16;
                int s = 0;
                int c = 0;
                while (i <= r * 16 + 16 - 1) {
                    if (i > bytes.length - 1) {
                        line.append("   ");
                    } else {
                        String hex = Integer.toHexString(bytes[i]).replaceAll("ffffff", "");
                        while (hex.length() < 2) {
                            hex = "0" + hex;
                        }
                        line.append(hex);
                        line.append(" ");
                    }
                    if (s == 7) {
                        line.append(" ");
                        s = 0;
                    } else {
                        ++s;
                    }
                    byte by = buffer[c] = i > bytes.length - 1 ? " ".getBytes()[0] : bytes[i];
                    if (buffer[c] >= 0 && buffer[c] <= 31 || buffer[c] == 127) {
                        buffer[c] = ".".getBytes()[0];
                    }
                    ++i;
                    ++c;
                }
                stream.println(line.toString() + new String(buffer));
            }
        }
    }
}

