/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.ldaps;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;

public class LDAPManagerConfig
implements Serializable {
    public static final int SEARCH_SCOPE_OBJECT = 0;
    public static final int SEARCH_SCOPE_ONELEVEL = 1;
    public static final int SEARCH_SCOPE_SUBTREE = 2;
    public static final String SECURITY_AUTHENTICATION_NONE = "none";
    public static final String SECURITY_AUTHENTICATION_SIMPLE = "simple";
    public static final String SECURITY_AUTHENTICATION_STRONG = "strong";
    public static final int DEFAULT_LDAP_PORT = 389;
    public static final int DEFAULT_LDAP_SSL_PORT = 636;
    public static final int DEFAULT_LDAP_VERSION = 3;
    public static final boolean DEFAULT_ANONYMOUS_BIND = false;
    public static final boolean DEFAULT_SSL_BIND = false;
    public static final String DEFAULT_SSL_SECURITY_LEVEL = "none";
    public static final int DEFAULT_SEARCH_SCOPE = 1;
    public static final int DEFAULT_COUNT_LIMIT = 0;
    public static final int DEFAULT_TIME_LIMIT = 0;
    public static final boolean DEFAULT_DEREF_LINK = false;
    public static final boolean DEFAULT_RETURN_OBJECT = false;
    private String host;
    private int port;
    private int version;
    private String baseDn;
    private boolean anonymousBind;
    private boolean sslConnection;
    private String sslSecurityLevel;
    private String userDn;
    private String userPassword;
    private int searchScope;
    private int countLimit;
    private int timeLimit;
    private boolean derefLink;
    private boolean returnObject;

    public LDAPManagerConfig(String host, int port, int version, String baseDn, boolean anonymousBind, boolean sslConnection, String sslSecurityLevel, String userDn, String userPassword, int searchScope, int countLimit, int timeLimit, boolean derefLink, boolean returnObject) {
        this.host = host;
        this.port = port;
        this.version = version;
        this.baseDn = baseDn;
        this.anonymousBind = anonymousBind;
        this.sslConnection = sslConnection;
        this.sslSecurityLevel = sslSecurityLevel;
        this.userDn = userDn;
        this.userPassword = userPassword;
        this.searchScope = searchScope;
        this.countLimit = countLimit;
        this.timeLimit = timeLimit;
        this.derefLink = derefLink;
        this.returnObject = returnObject;
    }

    public LDAPManagerConfig(String host, int port, int version, String baseDn, String userDn, String userPassword) {
        this(host, port, version, baseDn, false, false, "none", userDn, userPassword, 1, 0, 0, false, false);
    }

    public LDAPManagerConfig() {
        this(null, 389, 3, null, false, false, "none", null, null, 1, 0, 0, false, false);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public boolean isAnonymousBind() {
        return this.anonymousBind;
    }

    public void setAnonymousBind(boolean anonymousBind) {
        this.anonymousBind = anonymousBind;
    }

    public boolean isSslConnection() {
        return this.sslConnection;
    }

    public void setSslConnection(boolean sslConnection) {
        this.sslConnection = sslConnection;
    }

    public String getSslSecurityLevel() {
        return this.sslSecurityLevel;
    }

    public void setSslSecurityLevel(String sslSecurityLevel) {
        this.sslSecurityLevel = sslSecurityLevel;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public void setSearchScope(int searchScope) {
        this.searchScope = searchScope;
    }

    public int getCountLimit() {
        return this.countLimit;
    }

    public void setCountLimit(int countLimit) {
        this.countLimit = countLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public boolean isDerefLink() {
        return this.derefLink;
    }

    public void setDerefLink(boolean derefLink) {
        this.derefLink = derefLink;
    }

    public boolean isReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(boolean returnObject) {
        this.returnObject = returnObject;
    }

    public String createConnectionURL() {
        StringBuffer buffer = new StringBuffer();
        if (this.sslConnection) {
            buffer.append("ldaps://");
        } else {
            buffer.append("ldap://");
        }
        buffer.append(this.host);
        if (this.sslConnection) {
            buffer.append(this.port == 389 ? "" : ":").append(this.port);
        } else {
            buffer.append(this.port == 636 ? "" : ":").append(this.port);
        }
        return buffer.toString();
    }

    public DirContext createContext() throws NamingException {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.security.principal", this.userDn);
        environment.put("java.naming.security.credentials", this.userPassword);
        environment.put("java.naming.provider.url", this.createConnectionURL());
        environment.put("java.naming.ldap.version", String.valueOf(this.version));
        if (this.sslConnection) {
            environment.put("java.naming.security.authentication", this.sslSecurityLevel);
            environment.put("java.naming.security.protocol", "ssl");
        }
        return new InitialDirContext(environment);
    }

    public SearchControls createSearchControls() {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(this.searchScope);
        controls.setCountLimit(this.countLimit);
        controls.setTimeLimit(this.timeLimit);
        controls.setDerefLinkFlag(this.derefLink);
        controls.setReturningObjFlag(false);
        return controls;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("host=");
        buffer.append(this.host);
        buffer.append(",");
        buffer.append("port=");
        buffer.append(this.port);
        buffer.append(",");
        buffer.append("version=");
        buffer.append(this.version);
        buffer.append(",");
        buffer.append("baseDn=");
        buffer.append(this.baseDn);
        buffer.append(",");
        buffer.append("anonymousBind=");
        buffer.append(this.anonymousBind);
        buffer.append(",");
        buffer.append("sslConnection=");
        buffer.append(this.sslConnection);
        buffer.append(",");
        buffer.append("sslSecurityLevel=");
        buffer.append(this.sslSecurityLevel);
        buffer.append(",");
        buffer.append("userDn=");
        buffer.append(this.userDn);
        buffer.append(",");
        buffer.append("userPassword=");
        buffer.append(this.userPassword);
        buffer.append(",");
        buffer.append("searchScope=");
        buffer.append(this.searchScope);
        buffer.append(",");
        buffer.append("countLimit=");
        buffer.append(this.countLimit);
        buffer.append(",");
        buffer.append("timeLimit=");
        buffer.append(this.timeLimit);
        buffer.append(",");
        buffer.append("derefLink=");
        buffer.append(this.derefLink);
        buffer.append(",");
        buffer.append("returnObject=");
        buffer.append(this.returnObject);
        buffer.append("}");
        return buffer.toString();
    }
}

