/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.html;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class HTMLElement {
    private HTMLElement parent = null;
    private List childs = new LinkedList();

    public HTMLElement getParent() {
        return this.parent;
    }

    public void setParent(HTMLElement parent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setRoot() {
        this.setParent(null);
    }

    public abstract boolean isSupportChild();

    public void addChild(HTMLElement element) {
        if (!this.isSupportChild()) {
            throw new UnsupportedOperationException("addChild unsupported");
        }
        if (element == null) {
            throw new NullPointerException("element is null");
        }
        element.parent = this;
        this.childs.add(element);
    }

    public void removeChild(HTMLElement element) {
        if (!this.isSupportChild()) {
            throw new UnsupportedOperationException("removeChild unsupported");
        }
        if (element == null) {
            throw new NullPointerException("element is null");
        }
        if (!this.childs.contains(element)) {
            return;
        }
        element.parent = null;
        this.childs.remove(element);
    }

    public HTMLElement getChild(int index) {
        return (HTMLElement)this.childs.get(index);
    }

    protected List getChilds() {
        return this.childs;
    }

    public int getChildCount() {
        return this.childs.size();
    }

    public Iterator getChildIterator() {
        return this.childs.iterator();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("parent=");
        buffer.append(this.parent);
        buffer.append(",");
        buffer.append("childs=");
        buffer.append(this.childs);
        buffer.append("}");
        return buffer.toString();
    }
}

