/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.csv;

import java.io.Serializable;
import org.phosphoresce.commons.util.StringUtil;

public final class CSVToken
implements Serializable {
    public static final String SEPARATOR = ",";
    public static final String QUOTE = "\"";
    public static final String NEWLINE = "\n";
    private String value = null;

    public CSVToken() {
        this.value = "";
    }

    public CSVToken(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value == null ? "" : value;
    }

    public String getEncodedValue() {
        return CSVToken.encode(this.value);
    }

    public static String encode(String value) {
        if (StringUtil.isEmpty(value)) {
            return "";
        }
        if (value.indexOf(QUOTE) >= 0 || value.indexOf(SEPARATOR) >= 0 || value.indexOf(NEWLINE) >= 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(QUOTE);
            buffer.append(StringUtil.replace(value, QUOTE, "\"\""));
            buffer.append(QUOTE);
            return buffer.toString();
        }
        return value;
    }

    public static String decode(String value) {
        String render = value;
        if (render.startsWith(QUOTE) && render.endsWith(QUOTE)) {
            render = render.substring(1, render.length() - 1);
        }
        render = StringUtil.replace(render, "\"\"", QUOTE);
        return render;
    }

    public String toString() {
        return this.value;
    }
}

