/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.AbstractQuerySpec;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DrillThroughQuerySpec
extends AbstractQuerySpec {
    private final CellRequest request;
    private final List<String> columnNames;
    private final int maxColumnNameLength;

    public DrillThroughQuerySpec(CellRequest request, boolean countOnly) {
        super(request.getMeasure().getStar(), countOnly);
        this.request = request;
        int tmpMaxColumnNameLength = this.getStar().getSqlQueryDialect().getMaxColumnNameLength();
        this.maxColumnNameLength = tmpMaxColumnNameLength == 0 ? Integer.MAX_VALUE : tmpMaxColumnNameLength;
        this.columnNames = this.computeDistinctColumnNames();
    }

    private List<String> computeDistinctColumnNames() {
        RolapStar.Column[] columns;
        ArrayList<String> columnNames = new ArrayList<String>();
        HashSet<String> columnNameSet = new HashSet<String>();
        for (RolapStar.Column column : columns = this.getColumns()) {
            this.addColumnName(column, columnNames, columnNameSet);
        }
        this.addColumnName(this.request.getMeasure(), columnNames, columnNameSet);
        return columnNames;
    }

    private void addColumnName(RolapStar.Column column, List<String> columnNames, Set<String> columnNameSet) {
        String columnName = column.getName();
        if (columnName == null) {
            columnName = column.getExpression() instanceof MondrianDef.Column ? ((MondrianDef.Column)column.getExpression()).name : "c" + Integer.toString(columnNames.size());
        }
        String originalColumnName = columnName;
        if (columnName.length() > this.maxColumnNameLength) {
            columnName = columnName.substring(0, this.maxColumnNameLength);
        }
        int j = 0;
        while (!columnNameSet.add(columnName)) {
            String suffix = "_" + Integer.toString(j);
            columnName = originalColumnName;
            if (originalColumnName.length() + suffix.length() > this.maxColumnNameLength) {
                columnName = originalColumnName.substring(0, this.maxColumnNameLength - suffix.length());
            }
            columnName = columnName + suffix;
            ++j;
        }
        columnNames.add(columnName);
    }

    @Override
    public int getMeasureCount() {
        return 1;
    }

    @Override
    public RolapStar.Measure getMeasure(int i) {
        Util.assertTrue(i == 0);
        return this.request.getMeasure();
    }

    @Override
    public String getMeasureAlias(int i) {
        Util.assertTrue(i == 0);
        return this.columnNames.get(this.columnNames.size() - 1);
    }

    @Override
    public RolapStar.Column[] getColumns() {
        return this.request.getConstrainedColumns();
    }

    @Override
    public String getColumnAlias(int i) {
        return this.columnNames.get(i);
    }

    @Override
    public StarColumnPredicate getColumnPredicate(int i) {
        StarColumnPredicate constr = this.request.getValueList().get(i);
        return constr == null ? LiteralStarPredicate.TRUE : constr;
    }

    @Override
    public String generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        this.nonDistinctGenerateSql(sqlQuery);
        return sqlQuery.toString();
    }

    @Override
    protected void addMeasure(int i, SqlQuery sqlQuery) {
        RolapStar.Measure measure = this.getMeasure(i);
        Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
        measure.getTable().addToFrom(sqlQuery, false, true);
        String expr = measure.generateExprString(sqlQuery);
        sqlQuery.addSelect(expr, this.getMeasureAlias(i));
    }

    @Override
    protected boolean isAggregate() {
        return false;
    }

    @Override
    protected boolean isOrdered() {
        return true;
    }
}

