/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.MemberIterCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleIterCalc;
import mondrian.calc.impl.AbstractMemberListCalc;
import mondrian.calc.impl.AbstractTupleListCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.GenericIterCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MemberOrderKeyFunDef;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.SetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrderFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    public OrderFunDef(ResolverBase resolverBase, int type, int[] types) {
        super(resolverBase, type, types);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Calc expCalc;
        boolean tuple;
        IterCalc listCalc = compiler.compileIter(call.getArg(0));
        ArrayList<FunUtil.SortKeySpec> keySpecList = new ArrayList<FunUtil.SortKeySpec>();
        this.buildKeySpecList(keySpecList, call, compiler);
        int keySpecCount = keySpecList.size();
        Calc[] calcList = new Calc[keySpecCount + 1];
        calcList[0] = listCalc;
        boolean bl = tuple = ((SetType)listCalc.getType()).getArity() != 1;
        assert (keySpecCount >= 1);
        calcList[1] = expCalc = ((FunUtil.SortKeySpec)keySpecList.get(0)).getKey();
        if (keySpecCount == 1 && expCalc instanceof MemberValueCalc) {
            MemberCalc[] calcs;
            MemberValueCalc memberValueCalc = (MemberValueCalc)expCalc;
            ArrayList<MemberCalc> constantList = new ArrayList<MemberCalc>();
            ArrayList<MemberCalc> variableList = new ArrayList<MemberCalc>();
            for (MemberCalc memberCalc : calcs = (MemberCalc[])memberValueCalc.getCalcs()) {
                if (memberCalc instanceof ConstantCalc && !listCalc.dependsOn(memberCalc.getType().getDimension())) {
                    constantList.add(memberCalc);
                    continue;
                }
                variableList.add(memberCalc);
            }
            if (!constantList.isEmpty()) {
                if (variableList.isEmpty()) {
                    calcList[1] = new ValueCalc(new DummyExp(expCalc.getType()));
                    if (tuple) {
                        return new ContextCalc<Member[]>(calcs, new TupleCalcImpl(call, calcList, keySpecList));
                    }
                    return new ContextCalc<Member>(calcs, new MemberCalcImpl(call, calcList, keySpecList));
                }
                calcList[1] = new MemberValueCalc(new DummyExp(expCalc.getType()), variableList.toArray(new MemberCalc[variableList.size()]));
                if (tuple) {
                    return new ContextCalc<Member[]>(constantList.toArray(new MemberCalc[constantList.size()]), new TupleCalcImpl(call, calcList, keySpecList));
                }
                return new ContextCalc<Member>(constantList.toArray(new MemberCalc[constantList.size()]), new MemberCalcImpl(call, calcList, keySpecList));
            }
        }
        for (int i = 1; i < keySpecCount; ++i) {
            Calc expCalcs;
            calcList[i + 1] = expCalcs = ((FunUtil.SortKeySpec)keySpecList.get(i)).getKey();
        }
        if (tuple) {
            return new TupleCalcImpl(call, calcList, keySpecList);
        }
        return new MemberCalcImpl(call, calcList, keySpecList);
    }

    private void buildKeySpecList(List<FunUtil.SortKeySpec> keySpecList, ResolvedFunCall call, ExpCompiler compiler) {
        int argCount = call.getArgs().length;
        int j = 1;
        while (j < argCount) {
            FunUtil.Flag dir;
            Exp arg = call.getArg(j);
            Calc key = compiler.compileScalar(arg, true);
            if (++j >= argCount || call.getArg(j).getCategory() != 11) {
                dir = FunUtil.Flag.ASC;
            } else {
                dir = OrderFunDef.getLiteralArg(call, j, FunUtil.Flag.ASC, FunUtil.Flag.class);
                ++j;
            }
            keySpecList.add(new FunUtil.SortKeySpec(key, dir));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolverImpl
    extends ResolverBase {
        private final String[] reservedWords = FunUtil.Flag.getNames();
        static int[] argTypes;

        private ResolverImpl() {
            super("Order", "Order(<Set> {, <Key Specification>}...)", "Arranges members of a set, optionally preserving or breaking the hierarchy.", Syntax.Function);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            argTypes = new int[args.length];
            if (args.length < 2) {
                return null;
            }
            if (!validator.canConvert(args[0], 8, conversions)) {
                return null;
            }
            ResolverImpl.argTypes[0] = 8;
            int i = 1;
            while (i < args.length) {
                if (!validator.canConvert(args[i], 13, conversions)) {
                    return null;
                }
                ResolverImpl.argTypes[i] = 13;
                if (++i == args.length || !validator.canConvert(args[i], 11, conversions)) continue;
                ResolverImpl.argTypes[i] = 11;
                ++i;
            }
            return new OrderFunDef(this, 8, argTypes);
        }

        @Override
        public String[] getReservedWords() {
            if (this.reservedWords != null) {
                return this.reservedWords;
            }
            return super.getReservedWords();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextCalc<T>
    extends GenericIterCalc {
        private final MemberCalc[] memberCalcs;
        private final CalcWithDual calc;
        private final Calc[] calcs;
        private final Member[] members;

        protected ContextCalc(MemberCalc[] memberCalcs, CalcWithDual<T> calc) {
            super(new DummyExp(calc.getType()));
            this.memberCalcs = memberCalcs;
            this.calc = calc;
            this.calcs = new Calc[memberCalcs.length + 1];
            System.arraycopy(memberCalcs, 0, this.calcs, 0, memberCalcs.length);
            this.calcs[this.calcs.length - 1] = calc;
            this.members = new Member[memberCalcs.length];
        }

        @Override
        public Calc[] getCalcs() {
            return this.calcs;
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            for (int i = 0; i < this.memberCalcs.length; ++i) {
                this.members[i] = this.memberCalcs[i].evaluateMember(evaluator);
            }
            Evaluator subEval = evaluator.push(this.members);
            return this.calc.evaluateDual(evaluator, subEval);
        }

        @Override
        public boolean dependsOn(Dimension dimension) {
            if (ContextCalc.anyDepends(this.memberCalcs, dimension)) {
                return true;
            }
            for (MemberCalc memberCalc : this.memberCalcs) {
                if (!memberCalc.getType().usesDimension(dimension, true)) continue;
                return false;
            }
            return this.calc.dependsOn(dimension);
        }

        @Override
        public ResultStyle getResultStyle() {
            return this.calc.getResultStyle();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TupleCalcImpl
    extends AbstractTupleListCalc
    implements CalcWithDual<Member[]> {
        private final TupleIterCalc iterCalc;
        private final Calc[] sortKeyCalcList;
        private final List<FunUtil.SortKeySpec> keySpecList;
        private final int originalKeySpecCount;
        private final int arity;

        public TupleCalcImpl(ResolvedFunCall call, Calc[] calcList, List<FunUtil.SortKeySpec> keySpecList) {
            super(call, calcList);
            this.iterCalc = (TupleIterCalc)calcList[0];
            this.sortKeyCalcList = calcList;
            this.keySpecList = keySpecList;
            this.originalKeySpecCount = keySpecList.size();
            this.arity = this.getType().getArity();
        }

        @Override
        public List<Member[]> evaluateDual(Evaluator rootEvaluator, Evaluator subEvaluator) {
            assert (this.originalKeySpecCount == 1);
            Iterable<Member[]> iterable = this.iterCalc.evaluateTupleIterable(rootEvaluator);
            if (iterable instanceof List) {
                // empty if block
            }
            List<Member[]> list = null;
            Util.discard((Object)((Object)this.iterCalc.getResultStyle()));
            FunUtil.Flag sortKeyDir = this.keySpecList.get(0).getDirection();
            return FunUtil.sortTuples(subEvaluator.push(false), iterable, list, this.sortKeyCalcList[1], sortKeyDir.descending, sortKeyDir.brk, this.arity);
        }

        @Override
        public List<Member[]> evaluateTupleList(Evaluator evaluator) {
            Iterable<Member[]> iterable = this.iterCalc.evaluateTupleIterable(evaluator);
            if (iterable instanceof List) {
                // empty if block
            }
            List list = null;
            if (this.originalKeySpecCount == 1) {
                FunUtil.Flag sortKeyDir = this.keySpecList.get(0).getDirection();
                return FunUtil.sortTuples(evaluator.push(false), iterable, list, this.sortKeyCalcList[1], sortKeyDir.descending, sortKeyDir.brk, this.arity);
            }
            this.purgeKeySpecList(this.keySpecList, list);
            if (!this.keySpecList.isEmpty()) {
                return FunUtil.sortTuples(evaluator.push(false), iterable, list, this.keySpecList, this.arity);
            }
            return list;
        }

        @Override
        public Calc[] getCalcs() {
            return this.sortKeyCalcList;
        }

        @Override
        public List<Object> getArguments() {
            assert (this.originalKeySpecCount == 1);
            FunUtil.Flag sortKeyDir = this.keySpecList.get(0).getDirection();
            return Collections.singletonList(sortKeyDir.descending ? (sortKeyDir.brk ? FunUtil.Flag.BDESC : FunUtil.Flag.DESC) : (sortKeyDir.brk ? FunUtil.Flag.BASC : FunUtil.Flag.ASC));
        }

        @Override
        public boolean dependsOn(Dimension dimension) {
            return TupleCalcImpl.anyDependsButFirst(this.getCalcs(), dimension);
        }

        private void purgeKeySpecList(List<FunUtil.SortKeySpec> keySpecList, List list) {
            if (list == null || list.isEmpty()) {
                return;
            }
            if (keySpecList.size() == 1) {
                return;
            }
            Object head = list.get(0);
            ArrayList<Dimension> listDimensions = new ArrayList<Dimension>();
            if (head instanceof Object[]) {
                for (Object dim : (Object[])head) {
                    listDimensions.add(((Member)dim).getDimension());
                }
            } else {
                listDimensions.add(((Member)head).getDimension());
            }
            ListIterator<FunUtil.SortKeySpec> iter = keySpecList.listIterator();
            while (iter.hasNext()) {
                Calc[] calcs;
                MemberCalc memberCalc;
                FunUtil.SortKeySpec key = (FunUtil.SortKeySpec)iter.next();
                Calc expCalc = key.getKey();
                if (!(expCalc instanceof MemberOrderKeyFunDef.CalcImpl) || !((memberCalc = (MemberCalc)(calcs = ((MemberOrderKeyFunDef.CalcImpl)expCalc).getCalcs())[0]) instanceof ConstantCalc) && listDimensions.contains(memberCalc.getType().getDimension())) continue;
                iter.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberCalcImpl
    extends AbstractMemberListCalc
    implements CalcWithDual<Member> {
        private final MemberIterCalc listCalc;
        private final Calc[] sortKeyCalcList;
        private final List<FunUtil.SortKeySpec> keySpecList;
        private final int originalKeySpecCount;

        public MemberCalcImpl(ResolvedFunCall call, Calc[] calcList, List<FunUtil.SortKeySpec> keySpecList) {
            super(call, calcList);
            this.listCalc = (MemberIterCalc)calcList[0];
            this.sortKeyCalcList = calcList;
            this.keySpecList = keySpecList;
            this.originalKeySpecCount = keySpecList.size();
        }

        @Override
        public List<Member> evaluateDual(Evaluator rootEvaluator, Evaluator subEvaluator) {
            assert (this.originalKeySpecCount == 1);
            FunUtil.Flag sortKeyDir = this.keySpecList.get(0).getDirection();
            Iterable<Member> iterable = this.listCalc.evaluateMemberIterable(rootEvaluator);
            List<Member> list = null;
            return FunUtil.sortMembers(subEvaluator.push(false), iterable, list, this.sortKeyCalcList[1], sortKeyDir.descending, sortKeyDir.brk);
        }

        @Override
        public List<Member> evaluateMemberList(Evaluator evaluator) {
            Iterable<Member> iterable = this.listCalc.evaluateMemberIterable(evaluator);
            List list = null;
            if (this.originalKeySpecCount == 1) {
                FunUtil.Flag sortKeyDir = this.keySpecList.get(0).getDirection();
                return FunUtil.sortMembers(evaluator.push(false), iterable, list, this.sortKeyCalcList[1], sortKeyDir.descending, sortKeyDir.brk);
            }
            this.purgeKeySpecList(this.keySpecList, list);
            if (!this.keySpecList.isEmpty()) {
                return FunUtil.sortMembers(evaluator.push(false), iterable, list, this.keySpecList);
            }
            return list;
        }

        @Override
        public Calc[] getCalcs() {
            return this.sortKeyCalcList;
        }

        @Override
        public List<Object> getArguments() {
            assert (this.originalKeySpecCount == 1);
            FunUtil.Flag sortKeyDir = this.keySpecList.get(0).getDirection();
            return Collections.singletonList(sortKeyDir.descending ? (sortKeyDir.brk ? FunUtil.Flag.BDESC : FunUtil.Flag.DESC) : (sortKeyDir.brk ? FunUtil.Flag.BASC : FunUtil.Flag.ASC));
        }

        @Override
        public boolean dependsOn(Dimension dimension) {
            return MemberCalcImpl.anyDependsButFirst(this.getCalcs(), dimension);
        }

        private void purgeKeySpecList(List<FunUtil.SortKeySpec> keySpecList, List list) {
            if (list == null || list.isEmpty()) {
                return;
            }
            if (keySpecList.size() == 1) {
                return;
            }
            Object head = list.get(0);
            ArrayList<Dimension> listDimensions = new ArrayList<Dimension>();
            if (head instanceof Object[]) {
                for (Object dim : (Object[])head) {
                    listDimensions.add(((Member)dim).getDimension());
                }
            } else {
                listDimensions.add(((Member)head).getDimension());
            }
            ListIterator<FunUtil.SortKeySpec> iter = keySpecList.listIterator();
            while (iter.hasNext()) {
                Calc[] calcs;
                MemberCalc memberCalc;
                FunUtil.SortKeySpec key = (FunUtil.SortKeySpec)iter.next();
                Calc expCalc = key.getKey();
                if (!(expCalc instanceof MemberOrderKeyFunDef.CalcImpl) || !((memberCalc = (MemberCalc)(calcs = ((MemberOrderKeyFunDef.CalcImpl)expCalc).getCalcs())[0]) instanceof ConstantCalc) && listDimensions.contains(memberCalc.getType().getDimension())) continue;
                iter.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CalcWithDual<T>
    extends Calc {
        public List<T> evaluateDual(Evaluator var1, Evaluator var2);
    }
}

