/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.csv;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.phosphoresce.commons.csv.CSVToken;

public final class CSVRecord
implements Serializable {
    private List list = null;

    public CSVRecord() {
        this.list = new LinkedList();
    }

    public CSVRecord(CSVRecord record) {
        this.list = new LinkedList(record.list);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(CSVToken token) {
        return this.list.contains(token);
    }

    public boolean containsAll(CSVRecord record) {
        return this.list.containsAll(record.list);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public void expand(int size) {
        int listSize = this.list.size();
        for (int i = 0; i <= size - listSize; ++i) {
            this.list.add(new CSVToken());
        }
    }

    public CSVToken[] toArray() {
        return this.list.toArray(new CSVToken[this.list.size()]);
    }

    public boolean addAll(CSVRecord record) {
        return this.list.addAll(record.list);
    }

    public boolean addAll(int index, CSVRecord record) {
        this.expand(index);
        return this.list.addAll(index, record.list);
    }

    public boolean retainAll(CSVRecord record) {
        return this.list.retainAll(record.list);
    }

    public void clear() {
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public void add(CSVToken token) {
        this.list.add(token);
    }

    public void add(int index, CSVToken token) {
        this.expand(index);
        this.list.add(index, token);
    }

    public CSVToken get(int index) {
        this.expand(index + 1);
        return (CSVToken)this.list.get(index);
    }

    public CSVToken set(int index, CSVToken token) {
        this.expand(index + 1);
        return this.list.set(index, token);
    }

    public boolean remove(CSVToken token) {
        return this.list.remove(token);
    }

    public CSVToken remove(int index) {
        this.expand(index + 1);
        return (CSVToken)this.list.remove(index);
    }

    public boolean removeAll(CSVRecord record) {
        return this.list.removeAll(record.list);
    }

    public int indexOf(CSVToken token) {
        return this.list.indexOf(token);
    }

    public int lastIndexOf(CSVToken token) {
        return this.list.lastIndexOf(token);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int index) {
        this.expand(index);
        return this.list.listIterator(index);
    }

    public CSVRecord subList(int fromIndex, int toIndex) {
        this.expand(fromIndex);
        this.expand(toIndex);
        List record = this.list.subList(fromIndex, toIndex);
        CSVRecord result = new CSVRecord();
        Iterator iterator = record.iterator();
        while (iterator.hasNext()) {
            result.add((CSVToken)iterator.next());
        }
        return result;
    }

    public String getRecordValue() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            CSVToken token = (CSVToken)iterator.next();
            buffer.append(token.getEncodedValue());
            if (!iterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }
}

