/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultIndexManagerFactory
implements IndexManagerFactory {
    private static final Log log = LoggerFactory.make();

    @Override
    public IndexManager createDefaultIndexManager() {
        return new DirectoryBasedIndexManager();
    }

    @Override
    public IndexManager createIndexManagerByName(String indexManagerImplementationName) {
        if (StringHelper.isEmpty((String)indexManagerImplementationName)) {
            return this.createDefaultIndexManager();
        }
        String implName = indexManagerImplementationName.trim();
        IndexManager im = this.fromAlias(implName);
        if (im == null) {
            implName = this.aliasToFQN(implName);
            im = ClassLoaderHelper.instanceFromName(IndexManager.class, implName, IndexManagerHolder.class, "index manager");
        }
        log.indexManagerAliasResolved(indexManagerImplementationName, im.getClass());
        return im;
    }

    protected String aliasToFQN(String implName) {
        return implName;
    }

    protected IndexManager fromAlias(String implName) {
        if ("directory-based".equals(implName)) {
            return new DirectoryBasedIndexManager();
        }
        if ("near-real-time".equals(implName)) {
            return new NRTIndexManager();
        }
        return null;
    }
}

