/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static Serializable deepCopy(Serializable object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Serializable copyedObject = (Serializable)ois.readObject();
        oos.close();
        ois.close();
        return copyedObject;
    }

    public static void saveSerializableObject(Serializable object, OutputStream stream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(object);
        oos.flush();
        oos.close();
    }

    public static void saveSerializableObject(Serializable object, File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        ObjectUtil.saveSerializableObject(object, stream);
        stream.close();
    }

    public static void saveSerializableObject(Serializable object, String filename) throws IOException {
        ObjectUtil.saveSerializableObject(object, new File(filename));
    }

    public static Object loadSerializableObject(InputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(stream);
        Object object = ois.readObject();
        ois.close();
        return object;
    }

    public static Object loadSerializableObject(File file) throws IOException, ClassNotFoundException {
        FileInputStream stream = new FileInputStream(file);
        Object object = ObjectUtil.loadSerializableObject(stream);
        stream.close();
        return object;
    }

    public static Object loadSerializableObject(String filename) throws IOException, ClassNotFoundException {
        return ObjectUtil.loadSerializableObject(new File(filename));
    }
}

