/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.commons.database.accessor.FetchingList;
import org.phosphoresce.commons.database.accessor.RecordAccessorAbstract;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.accessor.ResultColumn;
import org.phosphoresce.commons.database.accessor.ResultRow;
import org.phosphoresce.commons.database.accessor.ResultTemplateColumn;
import org.phosphoresce.commons.database.accessor.ResultTemplateRow;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.IllegalResultTypeException;
import org.phosphoresce.commons.database.exception.IllegalTemplateException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public class RecordBufferedAccessor
extends RecordAccessorAbstract {
    protected List fetchBuffer = new FetchingList(this.getResultRowCount());
    private int fetchedCount = 0;

    public RecordBufferedAccessor(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        super(resultSet);
    }

    public final void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        this.rowDefinition.refreshResult(force);
        int currentRow = this.getResultSetRowIndex();
        LinkedList<ResultRow> removeList = new LinkedList<ResultRow>();
        int count = 0;
        Iterator iterator = this.fetchBuffer.iterator();
        while (iterator.hasNext()) {
            ResultRow row = (ResultRow)iterator.next();
            if (row != null) {
                row.refreshResult(force);
                if (row.state == ResultAccessorState.INSERT || row.state == ResultAccessorState.INSERT_DELETE || force && row.state == ResultAccessorState.INSERT_ERROR) {
                    removeList.add(row);
                }
                if (row.state != ResultAccessorState.REMOVED && row.state != ResultAccessorState.INSERT_ERROR) {
                    row.state = ResultAccessorState.STATIC;
                    for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; ++i) {
                        if (force) {
                            row.getColumn((int)i).state = ResultAccessorState.STATIC;
                            continue;
                        }
                        if (row.getColumn((int)i).state == ResultAccessorState.UPDATE_ERROR || row.getColumn((int)i).state == ResultAccessorState.INSERT_ERROR) continue;
                        row.getColumn((int)i).state = ResultAccessorState.STATIC;
                    }
                }
            }
            ++count;
        }
        this.fetchBuffer.removeAll(removeList);
        this.moveCurser(currentRow);
        if (this.validateStateListener()) {
            this.listener.bufferChanged();
        }
    }

    public final void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        int currentRow = this.getResultSetRowIndex();
        LinkedList<ResultRow> removeList = new LinkedList<ResultRow>();
        int count = 0;
        Iterator iterator = this.fetchBuffer.iterator();
        while (iterator.hasNext()) {
            ResultRow row = (ResultRow)iterator.next();
            if (row != null) {
                row.updateResult();
                if (row.state == ResultAccessorState.REMOVED || row.state == ResultAccessorState.INSERT_DELETE) {
                    removeList.add(row);
                    for (int i = count; i <= this.fetchBuffer.size() - 1; ++i) {
                        ResultRow suppliment = (ResultRow)this.fetchBuffer.get(i);
                        if (suppliment == null || suppliment.state == ResultAccessorState.REMOVED || suppliment.state == ResultAccessorState.INSERT || suppliment.state == ResultAccessorState.INSERT_DELETE) continue;
                        suppliment.setIndex(suppliment.getIndex() - 1);
                    }
                }
            }
            ++count;
        }
        this.fetchBuffer.removeAll(removeList);
        if (this.validateStateListener()) {
            this.listener.bufferChanged();
        }
        this.moveCurser(currentRow);
    }

    public final void clearStaticRecords() {
        if (this.fetchBuffer instanceof FetchingList) {
            ((FetchingList)this.fetchBuffer).clearStaticRecords();
        }
    }

    public final ResultRow getResultRow(int rowIndex) throws IllegalResultSetLocationIndexException, ResultSetAccessException, IllegalResultSetAdjustmentException {
        try {
            if (rowIndex > this.fetchBuffer.size() - 1) {
                throw new IllegalResultSetLocationIndexException(rowIndex + " row is over result set row index range");
            }
            if (rowIndex < 0) {
                throw new IllegalResultSetLocationIndexException(rowIndex + " row is negative index number");
            }
            if (this.fetchBuffer.get(rowIndex) == null) {
                this.log.trace((Object)("fetching row. [" + rowIndex + "]"));
                int currentRow = this.resultSet.getRow();
                this.resultSet.absolute(rowIndex + 1);
                this.fetchBuffer.set(rowIndex, new ResultRow(this.resultSet, ResultAccessorState.STATIC, this.listener, this.rowDefinition, rowIndex));
                this.moveCurser(currentRow);
            }
            return (ResultRow)this.fetchBuffer.get(rowIndex);
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to analyze record data", e);
        }
    }

    public final ResultColumn getResultColumn(int rowIndex, int columnIndex) throws IllegalResultSetLocationIndexException, ResultSetAccessException, IllegalResultSetAdjustmentException {
        try {
            int currentRow = this.resultSet.getRow();
            if (columnIndex > this.getResultColumnCount() - 1) {
                throw new IllegalResultSetLocationIndexException(columnIndex + " column is over result set column index range");
            }
            if (columnIndex < 0) {
                throw new IllegalResultSetLocationIndexException(columnIndex + " column is negative index number");
            }
            return this.getResultRow(rowIndex).getColumn(columnIndex);
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to analyze record data", e);
        }
    }

    public final ResultRow insertRow(ResultTemplateRow templateRow) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException, IllegalResultTypeException, IllegalTemplateException {
        ResultRow row = new ResultRow(this.resultSet, ResultAccessorState.INSERT, this.listener, this.rowDefinition, this.fetchBuffer.size());
        if (!row.getDefinition().equals(templateRow.getDefinition())) {
            throw new IllegalTemplateException("illegal different template information was specified");
        }
        for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; ++i) {
            ResultTemplateColumn templateColumn = templateRow.getColumn(i);
            ResultColumn column = row.getColumn(i);
            if (!column.getDefinition().equals(templateColumn.getDefinition())) {
                throw new IllegalTemplateException("illegal different template information was specified");
            }
            column.setValue(templateColumn.getValue());
        }
        this.fetchBuffer.add(row);
        if (this.validateStateListener()) {
            this.listener.rowInserted(this.fetchBuffer.size() - 1, this.fetchBuffer.size() - 1);
        }
        return row;
    }

    public final ResultRow insertRow() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        ResultRow row = new ResultRow(this.resultSet, ResultAccessorState.INSERT, this.listener, this.rowDefinition, this.fetchBuffer.size());
        this.fetchBuffer.add(row);
        if (this.validateStateListener()) {
            this.listener.rowInserted(this.fetchBuffer.size() - 1, this.fetchBuffer.size() - 1);
        }
        return row;
    }

    public final void deleteRow(int rowIndex) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        ResultRow row = this.getResultRow(rowIndex);
        if (row.state == ResultAccessorState.DELETE || row.state == ResultAccessorState.INSERT_DELETE) {
            return;
        }
        row.state = row.state == ResultAccessorState.INSERT || row.state == ResultAccessorState.INSERT_ERROR ? ResultAccessorState.INSERT_DELETE : ResultAccessorState.DELETE;
        for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; ++i) {
            ResultColumn column = row.getColumn(i);
            column.state = column.state == ResultAccessorState.INSERT ? ResultAccessorState.INSERT_DELETE : ResultAccessorState.DELETE;
        }
        if (this.validateStateListener()) {
            this.listener.rowUpdated(rowIndex, rowIndex);
        }
    }

    public final List fetch(int size) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        try {
            int currentRow = this.resultSet.getRow();
            if (this.fetchedCount <= 0) {
                this.resultSet.beforeFirst();
            } else {
                this.resultSet.absolute(this.fetchedCount);
            }
            int bufferedCount = this.fetchBuffer.size();
            int count = 0;
            LinkedList buffer = new LinkedList();
            while (this.resultSet.next()) {
                if (this.fetchBuffer.get(this.fetchedCount + count) == null) {
                    this.fetchBuffer.add(new ResultRow(this.resultSet, ResultAccessorState.STATIC, this.listener, this.rowDefinition, this.fetchedCount++));
                }
                buffer.add(this.fetchBuffer.get(this.fetchedCount + count));
                if (++count < size) continue;
            }
            if (this.validateStateListener()) {
                this.listener.rowUpdated(bufferedCount - 1, bufferedCount - 1 + count);
            }
            this.moveCurser(currentRow);
            return buffer;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to analyze record data", e);
        }
    }

    public final List fetchRemainAll() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        return this.fetch(this.getResultRowCount() - this.fetchedCount);
    }

    public final List fetchAll() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        this.fetchedCount = 0;
        return this.fetchRemainAll();
    }

    public final DatabaseError[] getErrors() throws IllegalResultSetLocationIndexException {
        LinkedList errors = new LinkedList();
        LinkedList<DatabaseError> rowErrors = new LinkedList<DatabaseError>();
        LinkedList<DatabaseError> columnErrors = new LinkedList<DatabaseError>();
        Iterator iterator = this.fetchBuffer.iterator();
        while (iterator.hasNext()) {
            ResultRow row = (ResultRow)iterator.next();
            if (row == null) continue;
            if (row.hasError()) {
                rowErrors.add(row.getError());
            }
            for (int i = 0; i <= this.rowDefinition.getColumnCount() - 1; ++i) {
                if (!row.getColumn(i).hasError()) continue;
                columnErrors.add(row.getColumn(i).getError());
            }
        }
        errors.addAll(rowErrors);
        errors.addAll(columnErrors);
        return errors.toArray(new DatabaseError[errors.size()]);
    }

    public final boolean hasError() throws IllegalResultSetLocationIndexException {
        Iterator iterator = this.fetchBuffer.iterator();
        while (iterator.hasNext()) {
            ResultRow row = (ResultRow)iterator.next();
            if (row == null) continue;
            if (row.hasError()) {
                return true;
            }
            for (int i = 0; i <= this.rowDefinition.getColumnCount() - 1; ++i) {
                if (!row.getColumn(i).hasError()) continue;
                return true;
            }
        }
        return false;
    }

    protected final void setResultColumn(int rowIndex, int columnIndex, ResultColumn column) throws IllegalResultSetLocationIndexException, ResultSetAccessException, IllegalResultSetAdjustmentException {
        this.getResultRow(rowIndex).setColumn(columnIndex, column);
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        if (this.resultSet.getStatement().getConnection() != null && !this.resultSet.getStatement().getConnection().isClosed()) {
            this.resultSet.getStatement().getConnection().rollback();
            this.resultSet.getStatement().getConnection().close();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("fetchedCount=");
        buffer.append(this.fetchedCount);
        buffer.append(",");
        buffer.append("rowDefinition=");
        buffer.append(this.rowDefinition);
        buffer.append("}");
        return buffer.toString();
    }
}

