/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.io;

import java.io.IOException;
import java.net.Socket;
import org.phosphoresce.socket.core.io.SocketStream;
import org.phosphoresce.socket.http.container.HttpSocketRequest;
import org.phosphoresce.socket.http.container.HttpSocketResponse;

public class HttpSocketStream
extends SocketStream {
    public HttpSocketStream(Socket socket) throws IOException {
        super(socket);
    }

    public HttpSocketStream(Socket socket, String match, String replace) throws IOException {
        super(socket, match, replace);
    }

    public void readRequest(HttpSocketRequest request) throws IOException {
        String header;
        request.setIdentifier(this.readLine());
        while ((header = this.readLine()).length() != 0) {
            request.addHeader(header);
        }
    }

    public void readResponse(HttpSocketResponse response) throws IOException {
        String header;
        response.setIdentifier(this.readLine());
        while ((header = this.readLine()).length() != 0) {
            response.addHeader(header);
        }
    }

    public void writeRequest(HttpSocketRequest request) throws IOException {
        this.writeLine(request.getIdentifier());
        String[] headerStrings = request.getHeaderStrings();
        for (int i = 0; i <= headerStrings.length - 1; ++i) {
            this.writeLine(headerStrings[i]);
        }
        this.writeSeparate();
    }

    public void writeResponse(HttpSocketResponse response) throws IOException {
        this.writeLine(response.getIdentifier());
        String[] headerStrings = response.getHeaderStrings();
        for (int i = 0; i <= headerStrings.length - 1; ++i) {
            this.writeLine(headerStrings[i]);
        }
        this.writeSeparate();
    }
}

