/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.phosphoresce.commons.util.StreamUtil;
import org.phosphoresce.socket.core.SocketGlobal;

public class HttpSocketContentOutputStream
extends OutputStream {
    private OutputStream stream = null;
    private boolean chunked = false;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private int bufferSize = SocketGlobal.DEFAULT_STREAM_BUFFER_SIZE;
    private long totalSize = 0L;

    private HttpSocketContentOutputStream() {
    }

    public HttpSocketContentOutputStream(OutputStream stream, boolean chunked, int bufferSize) throws IOException {
        this.stream = stream;
        this.chunked = chunked;
        this.bufferSize = bufferSize < 0 ? 1 : bufferSize;
        this.totalSize = 0L;
    }

    public HttpSocketContentOutputStream(OutputStream stream, boolean chunked) throws IOException {
        this.stream = stream;
        this.chunked = chunked;
        this.bufferSize = SocketGlobal.DEFAULT_STREAM_BUFFER_SIZE;
        this.totalSize = 0L;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void writeEOC() throws IOException {
        this.flushBuffer();
        StreamUtil.writeLine((OutputStream)this.stream, (String)"0");
        StreamUtil.writeLine((OutputStream)this.stream);
    }

    public void write(int data) throws IOException {
        this.buffer.write(data);
        if (this.buffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.buffer.write(bytes, offset, length);
        if (this.buffer.size() >= this.bufferSize) {
            this.flushBuffer();
        }
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    private void flushBuffer() throws IOException {
        if (this.buffer.size() <= 0) {
            return;
        }
        if (this.chunked) {
            StreamUtil.writeLine((OutputStream)this.stream, (String)Integer.toHexString(this.buffer.size()));
        }
        StreamUtil.writes((OutputStream)this.stream, (byte[])this.buffer.toByteArray());
        if (this.chunked) {
            StreamUtil.writeLine((OutputStream)this.stream);
        }
        this.totalSize += (long)this.buffer.size();
        this.buffer.reset();
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.stream.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.stream.flush();
        this.stream.close();
    }
}

