/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.container;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.phosphoresce.commons.util.StreamUtil;
import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.socket.http.container.HttpSocketRequest;

public class HttpSocketRequestPrameter {
    private Map parameter = new HashMap();
    private String charset;

    public HttpSocketRequestPrameter(String charset) {
        this.charset = charset;
    }

    private HttpSocketRequestPrameter() {
        this(null);
    }

    public static HttpSocketRequestPrameter createRequestParameter(String charset, String query) {
        HttpSocketRequestPrameter prameter = new HttpSocketRequestPrameter(charset);
        if (!StringUtil.isEmpty((String)query)) {
            String[] tokens = query.split("&");
            for (int i = 0; i <= tokens.length - 1; ++i) {
                String token = tokens[i];
                String name = token.indexOf("=") >= 0 ? token.substring(0, token.indexOf("=")) : "";
                String value = token.indexOf("=") >= 0 ? token.substring(token.indexOf("=") + 1) : "";
                prameter.put(name, value);
            }
        }
        return prameter;
    }

    public static HttpSocketRequestPrameter createRequestParameter(String charset, InputStream stream, int length) throws UnsupportedEncodingException, IOException {
        return HttpSocketRequestPrameter.createRequestParameter(charset, new String(StreamUtil.reads((InputStream)stream, (int)length), charset));
    }

    public static HttpSocketRequestPrameter createRequestParameter(String charset, HttpSocketRequest request) throws UnsupportedEncodingException, IOException {
        HttpSocketRequestPrameter parameter = request.getQueryParameter(charset);
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            HttpSocketRequestPrameter streamParameter = HttpSocketRequestPrameter.createRequestParameter(charset, new String(StreamUtil.reads((InputStream)request.getContentStream(), (int)request.getContentLength()), charset));
            parameter.putAll(streamParameter);
        }
        return parameter;
    }

    public void putAll(HttpSocketRequestPrameter parameter) {
        this.parameter.putAll(parameter.parameter);
    }

    public void put(String name, String value) {
        this.parameter.put(name, value);
    }

    public String get(String name) throws UnsupportedEncodingException {
        String value = (String)this.parameter.get(name);
        return value == null ? "" : URLDecoder.decode(value, this.charset);
    }

    public void remove(String name) {
        this.parameter.remove(name);
    }

    public int size() {
        return this.parameter.size();
    }

    public void clear() {
        this.parameter.clear();
    }

    public Set keySet() {
        return this.parameter.keySet();
    }

    public String createQueryString() throws UnsupportedEncodingException {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.parameter.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (StringUtil.isEmpty((String)name)) continue;
            buffer.append(name);
            buffer.append("=");
            buffer.append(this.get(name));
            if (!iterator.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }
}

