/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.container;

import org.phosphoresce.commons.util.StringUtil;

public class HttpSocketHeader {
    private String name;
    private String value;

    protected HttpSocketHeader(String name, String value) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException(name + " is invalid header name");
        }
        this.name = name;
        this.value = value;
    }

    protected HttpSocketHeader() {
        this(null, null);
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException(name + " is invalid header name");
        }
        this.name = name;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public int getValueOfInteger() {
        return StringUtil.isEmpty((String)this.value) || !StringUtil.isNumeric((String)this.value) ? -1 : StringUtil.parsePrimitiveInt((String)this.value);
    }

    public long getValueOfLong() {
        return StringUtil.isEmpty((String)this.value) || !StringUtil.isNumeric((String)this.value) ? -1L : StringUtil.parsePrimitiveLong((String)this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(int value) {
        this.value = String.valueOf(value);
    }

    public String getHeaderString() {
        StringBuffer buffer = new StringBuffer();
        if (!StringUtil.isEmpty((String)this.getName())) {
            buffer.append(this.getName());
            buffer.append(": ");
            buffer.append(this.getValue());
        }
        String result = buffer.toString().trim();
        return result;
    }

    public void setHeaderString(String header) {
        this.name = null;
        this.value = null;
        if (header == null || header.length() == 0) {
            return;
        }
        String[] tokens = header == null ? new String[]{} : header.split(":", 2);
        String name = null;
        String value = null;
        if (tokens.length >= 1) {
            name = tokens[0].trim();
        }
        if (tokens.length >= 2) {
            value = tokens[1].trim();
        }
        this.setName(name);
        this.setValue(value);
    }

    private boolean isValidName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return true;
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("name=");
        buffer.append(this.getName());
        buffer.append(",");
        buffer.append("value=");
        buffer.append(this.getValue());
        buffer.append("}");
        return buffer.toString();
    }
}

