/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.container;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.phosphoresce.commons.util.StringUtil;

public class HttpSocketCookie
implements Serializable,
Cloneable {
    private static final String[] RESERVED_NAMES = new String[]{"Expires", "Path", "Domain", "Secure", "Version", "Comment", "Discard", "Max-Age"};
    private String name;
    private String value;
    private Map options;

    protected HttpSocketCookie(String name, String value) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException(name + " is invalid cookie name");
        }
        this.name = name;
        this.value = value;
        this.options = new HashMap();
    }

    protected HttpSocketCookie() {
        this(null, null);
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException(name + " is invalid cookie name");
        }
        this.name = name;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public int getValueOfInteger() {
        return StringUtil.isEmpty((String)this.value) || !StringUtil.isNumeric((String)this.value) ? -1 : StringUtil.parsePrimitiveInt((String)this.value);
    }

    public long getValueOfLong() {
        return StringUtil.isEmpty((String)this.value) || !StringUtil.isNumeric((String)this.value) ? -1L : StringUtil.parsePrimitiveLong((String)this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(int value) {
        this.value = String.valueOf(value);
    }

    private String getCachedOptionName(String name) {
        if (name == null) {
            return null;
        }
        if ("".equals(name)) {
            return "";
        }
        Iterator iterator = this.options.keySet().iterator();
        while (iterator.hasNext()) {
            String cachedName = (String)iterator.next();
            if (!name.equalsIgnoreCase(cachedName)) continue;
            return cachedName;
        }
        throw new IllegalArgumentException(name + "is not exist cached options");
    }

    public boolean containsOption(String name) {
        Iterator iterator = this.options.keySet().iterator();
        while (iterator.hasNext()) {
            String cachedName = (String)iterator.next();
            if (!name.equalsIgnoreCase(cachedName)) continue;
            return true;
        }
        return false;
    }

    public void setOption(String name, String value) {
        if (this.containsOption(name)) {
            this.options.put(this.getCachedOptionName(name), value);
        } else {
            this.options.put(name, value);
        }
    }

    public String getOption(String name) {
        if (this.containsOption(name)) {
            String value = (String)this.options.get(this.getCachedOptionName(name));
            return value == null ? "" : value;
        }
        return "";
    }

    public String getCookieString() {
        String result;
        StringBuffer buffer = new StringBuffer();
        if (!StringUtil.isEmpty((String)this.getName())) {
            buffer.append(this.getName());
            if (!StringUtil.isEmpty((String)this.getValue())) {
                buffer.append("=");
                buffer.append(this.getValue());
            }
            buffer.append("; ");
            Iterator iterator = this.options.keySet().iterator();
            while (iterator.hasNext()) {
                String optionName = (String)iterator.next();
                String optionValue = this.getOption(optionName);
                buffer.append(optionName);
                if (StringUtil.isEmpty((String)optionValue)) continue;
                buffer.append("=");
                buffer.append(optionValue);
                buffer.append("; ");
            }
        }
        if ((result = buffer.toString().trim()).endsWith(";")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public void setCookieString(String cookie) {
        this.name = null;
        this.value = null;
        this.options.clear();
        if (cookie == null || cookie.length() == 0) {
            return;
        }
        String[] sets = cookie == null ? new String[]{} : cookie.split(";");
        for (int i = 0; i <= sets.length - 1; ++i) {
            String[] tokens = sets[i] == null ? new String[]{} : sets[i].split("=", 2);
            String name = null;
            String value = null;
            if (tokens.length >= 1) {
                name = tokens[0].trim();
            }
            if (tokens.length >= 2) {
                value = tokens[1].trim();
            }
            if (i == 0) {
                this.setName(name);
                this.setValue(value);
                continue;
            }
            this.setOption(name, value);
        }
    }

    private boolean isValidName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return true;
        }
        if (StringUtil.containsIgnoreCase((String[])RESERVED_NAMES, (String)name)) {
            return false;
        }
        return !name.startsWith("$");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("name=");
        buffer.append(this.getName());
        buffer.append(",");
        buffer.append("value=");
        buffer.append(this.getValue());
        buffer.append(",");
        buffer.append("options=");
        buffer.append(this.options.toString());
        buffer.append("}");
        return buffer.toString();
    }
}

