/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http;

import java.io.Serializable;

public final class HttpResponseStatus
implements Serializable {
    public static final HttpResponseStatus STATUS_100_CONTINUE = new HttpResponseStatus(100, "Continue", "", "\u51e6\u7406\u3092\u7d99\u7d9a\u3057\u3066\u3044\u307e\u3059\u3002\u7d9a\u304d\u306e\u30ea\u30af\u30a8\u30b9\u30c8\u3092\u9001\u4fe1\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
    public static final HttpResponseStatus STATUS_101_SWITCHING_PROTOCOLS = new HttpResponseStatus(101, "Switching Protocols", "", "Upgrade \u30d8\u30c3\u30c0\u3067\u6307\u5b9a\u3057\u305f\u30d7\u30ed\u30c8\u30b3\u30eb\u306b\u5909\u66f4\u3057\u3066\u518d\u8981\u6c42\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
    public static final HttpResponseStatus STATUS_200_OK = new HttpResponseStatus(200, "OK", "Action complete successfully.", "\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_201_CREATED = new HttpResponseStatus(201, "Created", "Success following a POST command.", "Location \u30d8\u30c3\u30c0\u3067\u6307\u5b9a\u3057\u305f\u5834\u6240\u306b\u65b0\u3057\u3044\u30b3\u30f3\u30c6\u30f3\u30c4\u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_202_ACCEPTED = new HttpResponseStatus(202, "Accepted", "The request has been accepted for processing, but the processing has not been completed.", "\u8981\u6c42\u306f\u53d7\u7406\u3055\u308c\u307e\u3057\u305f\u3002\u305f\u3060\u3057\u51e6\u7406\u306f\u5b8c\u4e86\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
    public static final HttpResponseStatus STATUS_203_NON_AUTHORITATIVE_INFORMATION = new HttpResponseStatus(203, "Non-Authoritative Information", "Response to a GET command, indicates that the returned meta information is from a private overlaid web.", "\u5fdc\u7b54\u30d8\u30c3\u30c0\u306f\u30aa\u30ea\u30b8\u30ca\u30eb\u30b5\u30fc\u30d0\u30fc\u304c\u8fd4\u3057\u305f\u3082\u306e\u3068\u306f\u7570\u306a\u308a\u307e\u3059\u304c\u3001\u51e6\u7406\u306f\u6210\u529f\u3067\u3059\u3002");
    public static final HttpResponseStatus STATUS_204_NO_CONTENT = new HttpResponseStatus(204, "No Content", "Server has received the request but there is no information to send back.", "\u30b3\u30f3\u30c6\u30f3\u30c4\u306f\u3042\u308a\u307e\u305b\u3093\u304c\u3001\u51e6\u7406\u306f\u6210\u529f\u3057\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_205_RESET_CONTENT = new HttpResponseStatus(205, "Reset Content", "Request fulfilled and user agent should reset document that caused the request. Used to allow user input followed by reseting the input form. The response MUST NOT include an entity.", "\u8981\u6c42\u3092\u53d7\u7406\u3057\u305f\u306e\u3067\u3001\u73fe\u5728\u306e\u30b3\u30f3\u30c6\u30f3\u30c4\uff08\u753b\u9762\uff09\u3092\u7834\u68c4\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3002");
    public static final HttpResponseStatus STATUS_206_PARTIAL_CONTENT = new HttpResponseStatus(206, "Partial Content", "The requested file was partially sent. Usually caused by stopping or refreshing a web page.", "\u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u4e00\u90e8\u306e\u307f\u8fd4\u5374\u3057\u307e\u3059\u3002");
    public static final HttpResponseStatus STATUS_300_MULTIPLE_CHOICES = new HttpResponseStatus(300, "Multiple Choices", "Requested resource corresponds to a set of representations, each with its own location. Negotiation information is provided so that the representation can be selected and redirect appropriately.", "\u30b3\u30f3\u30c6\u30f3\u30c4\u5165\u624b\u65b9\u6cd5\u306b\u3064\u3044\u3066\u8907\u6570\u306e\u9078\u629e\u80a2\u304c\u3042\u308a\u307e\u3059\u3002");
    public static final HttpResponseStatus STATUS_301_MOVED_PERMANENTLY = new HttpResponseStatus(301, "Moved Permanently", "Requested a directory instead of a file. The web server substituted the index.htm file.", "Location \u30d8\u30c3\u30c0\u3067\u6307\u5b9a\u3055\u308c\u305f\u5225\u306e\u5834\u6240\u306b\u79fb\u52d5\u3057\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_302_FOUND = new HttpResponseStatus(302, "Found", "The requested resource resides temporarily under a different URI. Since the redirection might be altered on occasion, the client SHOULD continue to use the Request-URI for future requests.", "Location \u30d8\u30c3\u30c0\u3067\u6307\u5b9a\u3055\u308c\u305f\u5225\u306e\u5834\u6240\u306b\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002\u305d\u3061\u3089\u3092\u898b\u3066\u304f\u3060\u3055\u3044\u3002");
    public static final HttpResponseStatus STATUS_303_SEE_OTHER = new HttpResponseStatus(303, "See Other", "The response to the request is at a different URI and should be retrieved there using a GET method. This allows the output of a POST-activated script to redirect the user agent to a selected resource.", "Location \u30d8\u30c3\u30c0\u3067\u6307\u5b9a\u3055\u308c\u305f\u4ed6\u306e\u5834\u6240\u3092\u898b\u3066\u304f\u3060\u3055\u3044\u3002");
    public static final HttpResponseStatus STATUS_304_NOT_MODIFIED = new HttpResponseStatus(304, "Not Modified", "The cached version of the requested file is the same as the file to be sent.", "\u66f4\u65b0\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002If-Modified-Since \u30d8\u30c3\u30c0\u3092\u7528\u3044\u305f\u5834\u5408\u306b\u8fd4\u5374\u3055\u308c\u307e\u3059\u3002");
    public static final HttpResponseStatus STATUS_305_USE_PROXY = new HttpResponseStatus(305, "Use Proxy", "The requested resource must be accessed through the proxy given in the Location field. The recipient should repeat this request via the proxy. This response must only be generated by origin servers.", "Location \u30d8\u30c3\u30c0\u3067\u6307\u5b9a\u3057\u305f\u30d7\u30ed\u30ad\u30b7\u3092\u4f7f\u7528\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
    public static final HttpResponseStatus STATUS_306_UNUSED = new HttpResponseStatus(306, "(Unused)", "Reserved for future use.", "\u672a\u4f7f\u7528\u3002");
    public static final HttpResponseStatus STATUS_307_TEMPORARY_REDIRECT = new HttpResponseStatus(307, "Temporary Redirect", "The requested resource resides temporarily under a different URI.", "\u5225\u306e\u5834\u6240\u306b\u4e00\u6642\u7684\u306b\u79fb\u52d5\u3057\u3066\u3044\u307e\u3059\u3002");
    public static final HttpResponseStatus STATUS_400_BAD_REQUEST = new HttpResponseStatus(400, "Bad Request", "The request could not be understood by the server due to malformed syntax. The client SHOULD NOT repeat the request without modifications.", "\u8981\u6c42\u304c\u4e0d\u6b63\u3067\u3059\u3002");
    public static final HttpResponseStatus STATUS_401_UNAUTHORIZED = new HttpResponseStatus(401, "Unauthorized", "User fail to provide a valid user name / password required for access to file / directory.", "\u8a8d\u8a3c\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    public static final HttpResponseStatus STATUS_402_PAYMENT_REQUIRED = new HttpResponseStatus(402, "Payment Required", "Reserved for future use.", "\u652f\u6255\u3044\u304c\u5fc5\u8981\u3067\u3059\u3002");
    public static final HttpResponseStatus STATUS_403_FORBIDDEN = new HttpResponseStatus(403, "Forbidden", "The server understood the request, but is refusing to fulfill it. Authorization will not help and the request SHOULD NOT be repeated.", "\u30a2\u30af\u30bb\u30b9\u304c\u8a8d\u3081\u3089\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    public static final HttpResponseStatus STATUS_404_NOT_FOUND = new HttpResponseStatus(404, "Not Found", "The server has not found anything matching the Request-URI. No indication is given of whether the condition is temporary or permanent.", "\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
    public static final HttpResponseStatus STATUS_405_METHOD_NOT_ALLOWED = new HttpResponseStatus(405, "Method Not Allowed", "The method in the Request-Line is not allowed for the resource identified by the Request-URI. The response must include an Allow header containing a list of valid methods for the requested resource.", "\u6307\u5b9a\u3057\u305f\u30e1\u30bd\u30c3\u30c9\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    public static final HttpResponseStatus STATUS_406_NOT_ACCEPTABLE = new HttpResponseStatus(406, "Not Acceptable", "The resource identified by the request is only capable of generating response entities which have content characteristics not acceptable according to the accept headers sent in the request.", "\u8a31\u53ef\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    public static final HttpResponseStatus STATUS_407_PROXY_AUTHENTICATION_REQUIRED = new HttpResponseStatus(407, "Proxy Authentication Required", "This code is similar to 401 (Unauthorized), but indicates that the client must first authenticate itself with the proxy.", "\u30d7\u30ed\u30ad\u30b7\u8a8d\u8a3c\u304c\u5fc5\u8981\u3067\u3059\u3002");
    public static final HttpResponseStatus STATUS_408_REQUEST_TIMEOUT = new HttpResponseStatus(408, "Request Timeout", "The client did not produce a request within the time that the server was prepared to wait. The client MAY repeat the request without modifications at any later time.", "\u30ea\u30af\u30a8\u30b9\u30c8\u304c\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_409_CONFLICT = new HttpResponseStatus(409, "Conflict", "The request could not be completed due to a conflict with the current state of the resource.", "\u30ea\u30af\u30a8\u30b9\u30c8\u304c\u30b3\u30f3\u30d5\u30ea\u30af\u30c8\uff08\u885d\u7a81\u30fb\u77db\u76fe\uff09\u3057\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_410_GONE = new HttpResponseStatus(410, "Gone", "The requested resource is no longer available at the server and no forwarding address is known.", "\u8981\u6c42\u3055\u308c\u305f\u30b3\u30f3\u30c6\u30f3\u30c4\u306f\u7121\u304f\u306a\u3063\u3066\u3057\u307e\u3044\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_411_LENGTH_REQUIRED = new HttpResponseStatus(411, "Length Required", "The server refuses to accept the request without a defined Content-Length of the message-body. The client may repeat the request if it adds it.", "Content-Length \u30d8\u30c3\u30c0\u3092\u4ed8\u52a0\u3057\u3066\u8981\u6c42\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
    public static final HttpResponseStatus STATUS_412_PRECONDITION_FAILED = new HttpResponseStatus(412, "Precondition Failed", "A condition in the header field data passed by the client evaluated false on the server. This lets the client prevent the requested method from being applied to a resource other than the one intended.", "If-... \u30d8\u30c3\u30c0\u3067\u6307\u5b9a\u3055\u308c\u305f\u6761\u4ef6\u306b\u5408\u81f4\u3057\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_413_REQUEST_ENTITY_TOO_LARGE = new HttpResponseStatus(413, "Request Entity Too Large", "The server refused to process the request because the request entity too large. The server may close the connection to prevent the client from continuing the request.", "\u8981\u6c42\u3055\u308c\u305f\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u304c\u5927\u304d\u3059\u304e\u307e\u3059\u3002");
    public static final HttpResponseStatus STATUS_414_REQUEST_URI_TOO_LONG = new HttpResponseStatus(414, "Request-URI Too Long", "The server is refusing to service the request because the Request-URI is longer than the server is willing to interpret.", "\u8981\u6c42\u3055\u308c\u305f URI \u304c\u9577\u3059\u304e\u307e\u3059\u3002");
    public static final HttpResponseStatus STATUS_415_UNSUPPORTED_MEDIA_TYPE = new HttpResponseStatus(415, "Unsupported Media Type", "The server is refusing to service the request because the entity of the request is in a format not supported by the requested resource for the requested method.", "\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u30e1\u30c7\u30a3\u30a2\u30bf\u30a4\u30d7\u3067\u3059\u3002");
    public static final HttpResponseStatus STATUS_416_REQUESTED_RANGE_NOT_SATISFIABLE = new HttpResponseStatus(416, "Requested Range Not Satisfiable", "A server SHOULD return a response with this status code if a request included a Range request-header field.", "\u8981\u6c42\u3055\u308c\u305f\u30ec\u30f3\u30b8\u304c\u4e0d\u6b63\u3067\u3059\u3002");
    public static final HttpResponseStatus STATUS_417_EXPECTATION_FAILED = new HttpResponseStatus(417, "Expectation Failed", "The server could not meet the expectation in an Expect request-header field. If the server is a proxy, the server has unambiguous evidence that the request could not be met by the next-hop server.", "Expect \u30d8\u30c3\u30c0\u3067\u6307\u5b9a\u3055\u308c\u305f\u62e1\u5f35\u8981\u6c42\u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_500_INTERNAL_SERVER_ERROR = new HttpResponseStatus(500, "Internal Server Error", "The server encountered an unexpected condition which prevented it from fulfilling the request.", "\u30b5\u30fc\u30d0\u30fc\u3067\u4e88\u671f\u3057\u306a\u3044\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_501_NOT_IMPLEMENTED = new HttpResponseStatus(501, "Not Implemented", "The server does not support the facility required.", "\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    public static final HttpResponseStatus STATUS_502_BAD_GATEWAY = new HttpResponseStatus(502, "Bad Gateway", "The server, while acting as a gateway or proxy, received an invalid response from the upstream server it accessed in attempting to fulfill the request.", "\u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u304c\u4e0d\u6b63\u3067\u3059\u3002");
    public static final HttpResponseStatus STATUS_503_SERVICE_UNAVAILABLE = new HttpResponseStatus(503, "Service Unavailable", "The server cannot process the request due to a system overload. This (should) be a temporary condition.", "\u30b5\u30fc\u30d3\u30b9\u306f\u5229\u7528\u53ef\u80fd\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    public static final HttpResponseStatus STATUS_504_GATEWAY_TIMEOUT = new HttpResponseStatus(504, "Gateway Timeout", "The service did not respond within the time frame that the gateway was willing to wait.", "\u30b2\u30fc\u30c8\u30a6\u30a7\u30a4\u304c\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3057\u307e\u3057\u305f\u3002");
    public static final HttpResponseStatus STATUS_505_HTTP_VERSION_NOT_SUPPORTED = new HttpResponseStatus(505, "HTTP Version Not Supported", "The server does not support, or refuses to support, the HTTP protocol version that was used in the request message.", "\u3053\u306eHTTP\u30d0\u30fc\u30b8\u30e7\u30f3\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    private static final HttpResponseStatus[] ALL_STATUS = new HttpResponseStatus[]{STATUS_100_CONTINUE, STATUS_101_SWITCHING_PROTOCOLS, STATUS_200_OK, STATUS_201_CREATED, STATUS_202_ACCEPTED, STATUS_203_NON_AUTHORITATIVE_INFORMATION, STATUS_204_NO_CONTENT, STATUS_205_RESET_CONTENT, STATUS_206_PARTIAL_CONTENT, STATUS_300_MULTIPLE_CHOICES, STATUS_301_MOVED_PERMANENTLY, STATUS_302_FOUND, STATUS_303_SEE_OTHER, STATUS_304_NOT_MODIFIED, STATUS_305_USE_PROXY, STATUS_306_UNUSED, STATUS_307_TEMPORARY_REDIRECT, STATUS_400_BAD_REQUEST, STATUS_401_UNAUTHORIZED, STATUS_402_PAYMENT_REQUIRED, STATUS_403_FORBIDDEN, STATUS_404_NOT_FOUND, STATUS_405_METHOD_NOT_ALLOWED, STATUS_406_NOT_ACCEPTABLE, STATUS_407_PROXY_AUTHENTICATION_REQUIRED, STATUS_408_REQUEST_TIMEOUT, STATUS_409_CONFLICT, STATUS_410_GONE, STATUS_411_LENGTH_REQUIRED, STATUS_412_PRECONDITION_FAILED, STATUS_413_REQUEST_ENTITY_TOO_LARGE, STATUS_414_REQUEST_URI_TOO_LONG, STATUS_415_UNSUPPORTED_MEDIA_TYPE, STATUS_416_REQUESTED_RANGE_NOT_SATISFIABLE, STATUS_417_EXPECTATION_FAILED, STATUS_500_INTERNAL_SERVER_ERROR, STATUS_501_NOT_IMPLEMENTED, STATUS_502_BAD_GATEWAY, STATUS_503_SERVICE_UNAVAILABLE, STATUS_504_GATEWAY_TIMEOUT, STATUS_505_HTTP_VERSION_NOT_SUPPORTED};
    private int code;
    private String message;
    private String description_en;
    private String description_ja;

    private HttpResponseStatus() {
    }

    public HttpResponseStatus(int code, String message, String description_en, String description_ja) {
        this.code = code;
        this.message = message;
        this.description_en = description_en;
        this.description_ja = description_ja;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescriptionEn() {
        return this.description_en;
    }

    public String getDescriptionJa() {
        return this.description_ja;
    }

    public static HttpResponseStatus getStatus(int code) {
        for (int i = 0; i <= ALL_STATUS.length - 1; ++i) {
            HttpResponseStatus status = ALL_STATUS[i];
            if (code != status.getCode()) continue;
            return status;
        }
        return new HttpResponseStatus(code, "", "", "");
    }

    public static HttpResponseStatus getStatus(int code, String defaultMessage) {
        HttpResponseStatus status = HttpResponseStatus.getStatus(code);
        if (status.getMessage().equals(defaultMessage)) {
            return status;
        }
        return new HttpResponseStatus(code, defaultMessage == null ? "" : defaultMessage, status.getDescriptionEn(), status.getDescriptionJa());
    }

    public static HttpResponseStatus getStatus(String code) {
        return HttpResponseStatus.getStatus(Integer.parseInt(code));
    }

    public static HttpResponseStatus getStatus(String code, String defaultMessage) {
        return HttpResponseStatus.getStatus(Integer.parseInt(code), defaultMessage);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.code;
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpResponseStatus other = (HttpResponseStatus)object;
        return this.code == other.code;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("code=");
        buffer.append(this.code);
        buffer.append(",");
        buffer.append("message=");
        buffer.append(this.message);
        buffer.append(",");
        buffer.append("description_en=");
        buffer.append(this.description_en);
        buffer.append(",");
        buffer.append("description_ja=");
        buffer.append(this.description_ja);
        buffer.append("}");
        return buffer.toString();
    }
}

