/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http;

public class HttpMimeMapping {
    public static final HttpMimeMapping ABS = new HttpMimeMapping("abs", "audio/x-mpeg");
    public static final HttpMimeMapping AI = new HttpMimeMapping("ai", "application/postscript");
    public static final HttpMimeMapping AIF = new HttpMimeMapping("aif", "audio/x-aiff");
    public static final HttpMimeMapping AIFC = new HttpMimeMapping("aifc", "audio/x-aiff");
    public static final HttpMimeMapping AIFF = new HttpMimeMapping("aiff", "audio/x-aiff");
    public static final HttpMimeMapping AIM = new HttpMimeMapping("aim", "application/x-aim");
    public static final HttpMimeMapping ART = new HttpMimeMapping("art", "image/x-jg");
    public static final HttpMimeMapping ASF = new HttpMimeMapping("asf", "video/x-ms-asf");
    public static final HttpMimeMapping ASX = new HttpMimeMapping("asx", "video/x-ms-asf");
    public static final HttpMimeMapping AU = new HttpMimeMapping("au", "audio/basic");
    public static final HttpMimeMapping AVI = new HttpMimeMapping("avi", "video/x-msvideo");
    public static final HttpMimeMapping AVX = new HttpMimeMapping("avx", "video/x-rad-screenplay");
    public static final HttpMimeMapping BCPIO = new HttpMimeMapping("bcpio", "application/x-bcpio");
    public static final HttpMimeMapping BIN = new HttpMimeMapping("bin", "application/octet-stream");
    public static final HttpMimeMapping BMP = new HttpMimeMapping("bmp", "image/bmp");
    public static final HttpMimeMapping BODY = new HttpMimeMapping("body", "text/html");
    public static final HttpMimeMapping CDF = new HttpMimeMapping("cdf", "application/x-cdf");
    public static final HttpMimeMapping CER = new HttpMimeMapping("cer", "application/x-x509-ca-cert");
    public static final HttpMimeMapping CLASS = new HttpMimeMapping("class", "application/java");
    public static final HttpMimeMapping CPIO = new HttpMimeMapping("cpio", "application/x-cpio");
    public static final HttpMimeMapping CSH = new HttpMimeMapping("csh", "application/x-csh");
    public static final HttpMimeMapping CSS = new HttpMimeMapping("css", "text/css");
    public static final HttpMimeMapping DIB = new HttpMimeMapping("dib", "image/bmp");
    public static final HttpMimeMapping DOC = new HttpMimeMapping("doc", "application/msword");
    public static final HttpMimeMapping DTD = new HttpMimeMapping("dtd", "text/plain");
    public static final HttpMimeMapping DV = new HttpMimeMapping("dv", "video/x-dv");
    public static final HttpMimeMapping DVI = new HttpMimeMapping("dvi", "application/x-dvi");
    public static final HttpMimeMapping EPS = new HttpMimeMapping("eps", "application/postscript");
    public static final HttpMimeMapping ETX = new HttpMimeMapping("etx", "text/x-setext");
    public static final HttpMimeMapping EXE = new HttpMimeMapping("exe", "application/octet-stream");
    public static final HttpMimeMapping GIF = new HttpMimeMapping("gif", "image/gif");
    public static final HttpMimeMapping GTAR = new HttpMimeMapping("gtar", "application/x-gtar");
    public static final HttpMimeMapping GZ = new HttpMimeMapping("gz", "application/x-gzip");
    public static final HttpMimeMapping HDF = new HttpMimeMapping("hdf", "application/x-hdf");
    public static final HttpMimeMapping HQX = new HttpMimeMapping("hqx", "application/mac-binhex40");
    public static final HttpMimeMapping HTC = new HttpMimeMapping("htc", "text/x-component");
    public static final HttpMimeMapping HTM = new HttpMimeMapping("htm", "text/html");
    public static final HttpMimeMapping HTML = new HttpMimeMapping("html", "text/html");
    public static final HttpMimeMapping IEF = new HttpMimeMapping("ief", "image/ief");
    public static final HttpMimeMapping JAD = new HttpMimeMapping("jad", "text/vnd.sun.j2me.app-descriptor");
    public static final HttpMimeMapping JAR = new HttpMimeMapping("jar", "application/java-archive");
    public static final HttpMimeMapping JAVA = new HttpMimeMapping("java", "text/plain");
    public static final HttpMimeMapping JNLP = new HttpMimeMapping("jnlp", "application/x-java-jnlp-file");
    public static final HttpMimeMapping JPE = new HttpMimeMapping("jpe", "image/jpeg");
    public static final HttpMimeMapping JPEG = new HttpMimeMapping("jpeg", "image/jpeg");
    public static final HttpMimeMapping JPG = new HttpMimeMapping("jpg", "image/jpeg");
    public static final HttpMimeMapping JS = new HttpMimeMapping("js", "text/javascript");
    public static final HttpMimeMapping JSF = new HttpMimeMapping("jsf", "text/plain");
    public static final HttpMimeMapping JSPF = new HttpMimeMapping("jspf", "text/plain");
    public static final HttpMimeMapping KAR = new HttpMimeMapping("kar", "audio/x-midi");
    public static final HttpMimeMapping LATEX = new HttpMimeMapping("latex", "application/x-latex");
    public static final HttpMimeMapping M3U = new HttpMimeMapping("m3u", "audio/x-mpegurl");
    public static final HttpMimeMapping MAC = new HttpMimeMapping("mac", "image/x-macpaint");
    public static final HttpMimeMapping MAN = new HttpMimeMapping("man", "application/x-troff-man");
    public static final HttpMimeMapping ME = new HttpMimeMapping("me", "application/x-troff-me");
    public static final HttpMimeMapping MID = new HttpMimeMapping("mid", "audio/x-midi");
    public static final HttpMimeMapping MIDI = new HttpMimeMapping("midi", "audio/x-midi");
    public static final HttpMimeMapping MIF = new HttpMimeMapping("mif", "application/x-mif");
    public static final HttpMimeMapping MOV = new HttpMimeMapping("mov", "video/quicktime");
    public static final HttpMimeMapping MOVIE = new HttpMimeMapping("movie", "video/x-sgi-movie");
    public static final HttpMimeMapping MP1 = new HttpMimeMapping("mp1", "audio/x-mpeg");
    public static final HttpMimeMapping MP2 = new HttpMimeMapping("mp2", "audio/x-mpeg");
    public static final HttpMimeMapping MP3 = new HttpMimeMapping("mp3", "audio/x-mpeg");
    public static final HttpMimeMapping MPA = new HttpMimeMapping("mpa", "audio/x-mpeg");
    public static final HttpMimeMapping MPE = new HttpMimeMapping("mpe", "video/mpeg");
    public static final HttpMimeMapping MPEG = new HttpMimeMapping("mpeg", "video/mpeg");
    public static final HttpMimeMapping MPEGA = new HttpMimeMapping("mpega", "audio/x-mpeg");
    public static final HttpMimeMapping MPG = new HttpMimeMapping("mpg", "video/mpeg");
    public static final HttpMimeMapping MPV2 = new HttpMimeMapping("mpv2", "video/mpeg2");
    public static final HttpMimeMapping MS = new HttpMimeMapping("ms", "application/x-wais-source");
    public static final HttpMimeMapping NC = new HttpMimeMapping("nc", "application/x-netcdf");
    public static final HttpMimeMapping ODA = new HttpMimeMapping("oda", "application/oda");
    public static final HttpMimeMapping PBM = new HttpMimeMapping("pbm", "image/x-portable-bitmap");
    public static final HttpMimeMapping PCT = new HttpMimeMapping("pct", "image/pict");
    public static final HttpMimeMapping PDF = new HttpMimeMapping("pdf", "application/pdf");
    public static final HttpMimeMapping PGM = new HttpMimeMapping("pgm", "image/x-portable-graymap");
    public static final HttpMimeMapping PIC = new HttpMimeMapping("pic", "image/pict");
    public static final HttpMimeMapping PICT = new HttpMimeMapping("pict", "image/pict");
    public static final HttpMimeMapping PLS = new HttpMimeMapping("pls", "audio/x-scpls");
    public static final HttpMimeMapping PNG = new HttpMimeMapping("png", "image/png");
    public static final HttpMimeMapping PNM = new HttpMimeMapping("pnm", "image/x-portable-anymap");
    public static final HttpMimeMapping PNT = new HttpMimeMapping("pnt", "image/x-macpaint");
    public static final HttpMimeMapping PPM = new HttpMimeMapping("ppm", "image/x-portable-pixmap");
    public static final HttpMimeMapping PPT = new HttpMimeMapping("ppt", "application/powerpoint");
    public static final HttpMimeMapping PS = new HttpMimeMapping("ps", "application/postscript");
    public static final HttpMimeMapping PSD = new HttpMimeMapping("psd", "image/x-photoshop");
    public static final HttpMimeMapping QT = new HttpMimeMapping("qt", "video/quicktime");
    public static final HttpMimeMapping QTI = new HttpMimeMapping("qti", "image/x-quicktime");
    public static final HttpMimeMapping QTIF = new HttpMimeMapping("qtif", "image/x-quicktime");
    public static final HttpMimeMapping RAS = new HttpMimeMapping("ras", "image/x-cmu-raster");
    public static final HttpMimeMapping RGB = new HttpMimeMapping("rgb", "image/x-rgb");
    public static final HttpMimeMapping RM = new HttpMimeMapping("rm", "application/vnd.rn-realmedia");
    public static final HttpMimeMapping ROFF = new HttpMimeMapping("roff", "application/x-troff");
    public static final HttpMimeMapping RTF = new HttpMimeMapping("rtf", "application/rtf");
    public static final HttpMimeMapping RTX = new HttpMimeMapping("rtx", "text/richtext");
    public static final HttpMimeMapping SH = new HttpMimeMapping("sh", "application/x-sh");
    public static final HttpMimeMapping SHAR = new HttpMimeMapping("shar", "application/x-shar");
    public static final HttpMimeMapping SMF = new HttpMimeMapping("smf", "audio/x-midi");
    public static final HttpMimeMapping SIT = new HttpMimeMapping("sit", "application/x-stuffit");
    public static final HttpMimeMapping SND = new HttpMimeMapping("snd", "audio/basic");
    public static final HttpMimeMapping SRC = new HttpMimeMapping("src", "application/x-wais-source");
    public static final HttpMimeMapping SV4CPIO = new HttpMimeMapping("sv4cpio", "application/x-sv4cpio");
    public static final HttpMimeMapping SV4CRC = new HttpMimeMapping("sv4crc", "application/x-sv4crc");
    public static final HttpMimeMapping SWF = new HttpMimeMapping("swf", "application/x-shockwave-flash");
    public static final HttpMimeMapping T = new HttpMimeMapping("t", "application/x-troff");
    public static final HttpMimeMapping TAR = new HttpMimeMapping("tar", "application/x-tar");
    public static final HttpMimeMapping TCL = new HttpMimeMapping("tcl", "application/x-tcl");
    public static final HttpMimeMapping TEX = new HttpMimeMapping("tex", "application/x-tex");
    public static final HttpMimeMapping TEXI = new HttpMimeMapping("texi", "application/x-texinfo");
    public static final HttpMimeMapping TEXINFO = new HttpMimeMapping("texinfo", "application/x-texinfo");
    public static final HttpMimeMapping TIF = new HttpMimeMapping("tif", "image/tiff");
    public static final HttpMimeMapping TIFF = new HttpMimeMapping("tiff", "image/tiff");
    public static final HttpMimeMapping TR = new HttpMimeMapping("tr", "application/x-troff");
    public static final HttpMimeMapping TSV = new HttpMimeMapping("tsv", "text/tab-separated-values");
    public static final HttpMimeMapping TXT = new HttpMimeMapping("txt", "text/plain");
    public static final HttpMimeMapping ULW = new HttpMimeMapping("ulw", "audio/basic");
    public static final HttpMimeMapping USTAR = new HttpMimeMapping("ustar", "application/x-ustar");
    public static final HttpMimeMapping XBM = new HttpMimeMapping("xbm", "image/x-xbitmap");
    public static final HttpMimeMapping XHT = new HttpMimeMapping("xht", "application/xhtml+xml");
    public static final HttpMimeMapping XHTML = new HttpMimeMapping("xhtml", "application/xhtml+xml");
    public static final HttpMimeMapping XML = new HttpMimeMapping("xml", "text/xml");
    public static final HttpMimeMapping XPM = new HttpMimeMapping("xpm", "image/x-xpixmap");
    public static final HttpMimeMapping XSL = new HttpMimeMapping("xsl", "text/xml");
    public static final HttpMimeMapping XWD = new HttpMimeMapping("xwd", "image/x-xwindowdump");
    public static final HttpMimeMapping WAV = new HttpMimeMapping("wav", "audio/x-wav");
    public static final HttpMimeMapping SVG = new HttpMimeMapping("svg", "image/svg+xml");
    public static final HttpMimeMapping SVGZ = new HttpMimeMapping("svgz", "image/svg+xml");
    public static final HttpMimeMapping VSD = new HttpMimeMapping("vsd", "application/x-visio");
    public static final HttpMimeMapping WBMP = new HttpMimeMapping("wbmp", "image/vnd.wap.wbmp");
    public static final HttpMimeMapping WML = new HttpMimeMapping("wml", "text/vnd.wap.wml");
    public static final HttpMimeMapping WMLC = new HttpMimeMapping("wmlc", "application/vnd.wap.wmlc");
    public static final HttpMimeMapping WMLS = new HttpMimeMapping("wmls", "text/vnd.wap.wmlscript");
    public static final HttpMimeMapping WMLSCRIPTC = new HttpMimeMapping("wmlscriptc", "application/vnd.wap.wmlscriptc");
    public static final HttpMimeMapping WRL = new HttpMimeMapping("wrl", "x-world/x-vrml");
    public static final HttpMimeMapping Z = new HttpMimeMapping("Z", "application/x-compress");
    public static final HttpMimeMapping ZIP = new HttpMimeMapping("zip", "application/zip");
    private static final HttpMimeMapping[] ALL_MIME_MAPPING = new HttpMimeMapping[]{ABS, AI, AIF, AIFC, AIFF, AIM, ART, ASF, ASX, AU, AVI, AVX, BCPIO, BIN, BMP, BODY, CDF, CER, CLASS, CPIO, CSH, CSS, DIB, DOC, DTD, DV, DVI, EPS, ETX, EXE, GIF, GTAR, GZ, HDF, HQX, HTC, HTM, HTML, IEF, JAD, JAR, JAVA, JNLP, JPE, JPEG, JPG, JS, JSF, JSPF, KAR, LATEX, M3U, MAC, MAN, ME, MID, MIDI, MIF, MOV, MOVIE, MP1, MP2, MP3, MPA, MPE, MPEG, MPEGA, MPG, MPV2, MS, NC, ODA, PBM, PCT, PDF, PGM, PIC, PICT, PLS, PNG, PNM, PNT, PPM, PPT, PS, PSD, QT, QTI, QTIF, RAS, RGB, RM, ROFF, RTF, RTX, SH, SHAR, SMF, SIT, SND, SRC, SV4CPIO, SV4CRC, SWF, T, TAR, TCL, TEX, TEXI, TEXINFO, TIF, TIFF, TR, TSV, TXT, ULW, USTAR, XBM, XHT, XHTML, XML, XPM, XSL, XWD, WAV, SVG, SVGZ, VSD, WBMP, WML, WMLC, WMLS, WMLSCRIPTC, WRL, Z, ZIP};
    private String extension;
    private String mimeType;

    private HttpMimeMapping() {
    }

    public HttpMimeMapping(String extension, String mimeType) {
        this.extension = extension;
        this.mimeType = mimeType;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static HttpMimeMapping getMapping(String extension) {
        for (int i = 0; i <= ALL_MIME_MAPPING.length - 1; ++i) {
            HttpMimeMapping mapping = ALL_MIME_MAPPING[i];
            if (!mapping.getExtension().equalsIgnoreCase(extension)) continue;
            return mapping;
        }
        return new HttpMimeMapping(extension, "application/" + extension);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.extension == null ? 0 : this.extension.toLowerCase().hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpMimeMapping other = (HttpMimeMapping)object;
        if (this.extension == null ? other.extension != null : !this.extension.equalsIgnoreCase(other.extension)) {
            return false;
        }
        return !(this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("extension=");
        buffer.append(this.extension);
        buffer.append(",");
        buffer.append("mimeType=");
        buffer.append(this.mimeType);
        buffer.append("}");
        return buffer.toString();
    }
}

