/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.core.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import org.phosphoresce.commons.io.ReplacableOutputStream;
import org.phosphoresce.commons.util.ByteFIFOStack;
import org.phosphoresce.commons.util.ByteUtil;

public class SocketStream {
    public static final String DEFAULT_SEPARATOR = "\r\n";
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    protected static boolean dumpTrace = false;
    protected static PrintStream dumpTraceStream = System.out;

    private SocketStream() {
    }

    public SocketStream(Socket socket, String match, String replace) throws IOException {
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = new ReplacableOutputStream(socket.getOutputStream(), match, replace);
    }

    public SocketStream(Socket socket) throws IOException {
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public static boolean isDumpTrace() {
        return dumpTrace;
    }

    public static void setDumpTrace(boolean dumpTrace) {
        SocketStream.dumpTrace = dumpTrace;
    }

    public static PrintStream getDumpTraceStream() {
        return dumpTraceStream;
    }

    public static void setDumpTraceStream(PrintStream dumpTraceStream) {
        SocketStream.dumpTraceStream = dumpTraceStream;
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    public int read() throws IOException {
        return this.inputStream.read();
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.inputStream.read(bytes, offset, length);
    }

    public int read(byte[] bytes) throws IOException {
        return this.inputStream.read(bytes);
    }

    public long skip(long length) throws IOException {
        return this.inputStream.skip(length);
    }

    public boolean markSupported() throws IOException {
        return this.inputStream.markSupported();
    }

    public synchronized void mark(int readlimit) throws IOException {
        this.inputStream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public String readLine(String separator) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        ByteFIFOStack stack = new ByteFIFOStack(separator.length());
        int b = -1;
        while ((b = this.inputStream.read()) != -1) {
            byte[] data = stack.push(b);
            byteOutputStream.write(data);
            if (!separator.equals(new String(stack.getBytes()))) continue;
            break;
        }
        String value = new String(byteOutputStream.toByteArray());
        return value;
    }

    public String readLine() throws IOException {
        return this.readLine(DEFAULT_SEPARATOR);
    }

    public void skipLine(String separator) throws IOException {
        this.readLine(separator);
    }

    public void skipLine() throws IOException {
        this.readLine(DEFAULT_SEPARATOR);
    }

    public byte[] reads(int length) throws IOException {
        byte[] readed;
        if (length <= 0) {
            return new byte[0];
        }
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        int i = 0;
        int b = -1;
        while ((b = this.inputStream.read()) != -1) {
            byteOutputStream.write(b);
            if (++i < length) continue;
        }
        if ((readed = byteOutputStream.toByteArray()).length == length) {
            return readed;
        }
        byte[] result = new byte[length];
        System.arraycopy(readed, 0, result, 0, length);
        return result;
    }

    public byte[] reads() throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        int b = -1;
        while (this.inputStream.available() > 0 && (b = this.inputStream.read()) != -1) {
            byteOutputStream.write(b);
        }
        return byteOutputStream.toByteArray();
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
        if (dumpTrace && dumpTraceStream != null) {
            dumpTraceStream.println("write 1byte = " + b);
        }
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.outputStream.write(bytes, offset, length);
        if (dumpTrace && dumpTraceStream != null) {
            dumpTraceStream.println("write " + bytes.length + "bytes");
            ByteUtil.printByteTrace((byte[])bytes, (PrintStream)dumpTraceStream);
        }
    }

    public void write(byte[] bytes) throws IOException {
        this.outputStream.write(bytes);
        if (dumpTrace && dumpTraceStream != null) {
            dumpTraceStream.println("write " + bytes.length + "bytes");
            ByteUtil.printByteTrace((byte[])bytes, (PrintStream)dumpTraceStream);
        }
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void writeLine(String line, boolean withSeparator, String separator) throws IOException {
        this.outputStream.write(line.getBytes());
        if (dumpTrace && dumpTraceStream != null) {
            dumpTraceStream.println("write " + line.getBytes().length + "bytes");
            ByteUtil.printByteTrace((byte[])line.getBytes(), (PrintStream)dumpTraceStream);
        }
        if (withSeparator) {
            this.outputStream.write(separator.getBytes());
        }
        if (dumpTrace && dumpTraceStream != null) {
            dumpTraceStream.println("write " + separator.getBytes().length + "bytes");
            ByteUtil.printByteTrace((byte[])separator.getBytes(), (PrintStream)dumpTraceStream);
        }
    }

    public void writeLine(String line, boolean withSeparator) throws IOException {
        this.writeLine(line, withSeparator, DEFAULT_SEPARATOR);
    }

    public void writeLine(String line, String separator) throws IOException {
        this.writeLine(line, true, separator);
    }

    public void writeLine(String line) throws IOException {
        this.writeLine(line, true, DEFAULT_SEPARATOR);
    }

    public void writeSeparate(String separator) throws IOException {
        this.outputStream.write(separator.getBytes());
    }

    public void writeSeparate() throws IOException {
        this.outputStream.write(DEFAULT_SEPARATOR.getBytes());
    }
}

