/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.core.io;

import java.io.IOException;
import java.net.Socket;
import org.phosphoresce.socket.core.io.SocketStream;

public class SocketRelayStream {
    protected SocketStream source;
    protected SocketStream destination;
    protected boolean streaming;

    public SocketRelayStream() {
        this.source = null;
        this.destination = null;
        this.streaming = false;
    }

    public SocketRelayStream(SocketStream source, SocketStream destination) {
        this.source = source;
        this.destination = destination;
        this.streaming = false;
    }

    public SocketRelayStream(Socket source, Socket destination) throws IOException {
        this.source = source == null ? null : new SocketStream(source);
        this.destination = destination == null ? null : new SocketStream(destination);
        this.streaming = false;
    }

    public Socket getSourceSocket() {
        return this.source.getSocket();
    }

    public void setSourceSocket(Socket source) throws IOException {
        this.source = source == null ? null : new SocketStream(source);
    }

    public SocketStream getSourceStream() {
        return this.source;
    }

    public void setSourceStream(SocketStream source) {
        this.source = source;
    }

    public Socket getDestinationSocket() {
        return this.destination.getSocket();
    }

    public void setDestinationSocket(Socket destination) throws IOException {
        this.destination = destination == null ? null : new SocketStream(destination);
    }

    public SocketStream getDestinationStream() {
        return this.destination;
    }

    public void setDestinationStream(SocketStream destination) {
        this.destination = destination;
    }

    public void reverseStreamVector() throws IOException {
        if (this.streaming) {
            throw new IOException("Stream is processing");
        }
        SocketStream temporary = this.source;
        this.source = this.destination;
        this.destination = temporary;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.streaming = true;
        try {
            if (this.source != null) {
                this.source.close();
            }
            if (this.destination != null) {
                this.destination.close();
            }
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        this.streaming = true;
        try {
            int n = this.source.available();
            return n;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        this.streaming = true;
        try {
            int n = this.source.read();
            return n;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes, int offset, int length) throws IOException {
        this.streaming = true;
        try {
            int n = this.source.read(bytes, offset, length);
            return n;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes) throws IOException {
        this.streaming = true;
        try {
            int n = this.source.read(bytes);
            return n;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        this.streaming = true;
        try {
            String string = this.source.readLine();
            return string;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] reads() throws IOException {
        this.streaming = true;
        try {
            byte[] byArray = this.source.reads();
            return byArray;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] reads(int length) throws IOException {
        this.streaming = true;
        try {
            byte[] byArray = this.source.reads(length);
            return byArray;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long length) throws IOException {
        this.streaming = true;
        try {
            long l = this.source.skip(length);
            return l;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readlimit) throws IOException {
        this.streaming = true;
        try {
            this.source.mark(readlimit);
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markSupported() throws IOException {
        this.streaming = true;
        try {
            boolean bl = this.source.markSupported();
            return bl;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        this.streaming = true;
        try {
            this.source.reset();
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipLine() throws IOException {
        this.streaming = true;
        try {
            this.source.skipLine();
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        this.streaming = true;
        try {
            this.destination.flush();
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.streaming = true;
        try {
            this.destination.write(bytes, offset, length);
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) throws IOException {
        this.streaming = true;
        try {
            this.destination.write(bytes);
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        this.streaming = true;
        try {
            this.destination.write(b);
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLine(String line, boolean withSeparator) throws IOException {
        this.streaming = true;
        try {
            this.destination.writeLine(line, withSeparator);
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLine(String line) throws IOException {
        this.streaming = true;
        try {
            this.destination.writeLine(line);
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSeparate() throws IOException {
        this.streaming = true;
        try {
            this.destination.writeSeparate();
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int foward() throws IOException {
        this.streaming = true;
        try {
            int b = this.source.read();
            this.destination.write(b);
            int n = b;
            return n;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] forward(int length) throws IOException {
        this.streaming = true;
        try {
            byte[] bytes = this.source.reads(length);
            this.destination.write(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forward(int length, int bufferSize) throws IOException {
        this.streaming = true;
        try {
            int avaivable = length;
            int readSize = -1;
            int readed = 0;
            do {
                readSize = avaivable >= bufferSize ? bufferSize : avaivable;
                byte[] bytes = this.forward(readSize);
                readed += bytes.length;
            } while ((avaivable -= readSize) > 0);
            int n = readed;
            return n;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forwardEOS(int bufferSize) throws IOException {
        this.streaming = true;
        try {
            int readed = 0;
            while (this.source.available() > 0) {
                int readSize = bufferSize > this.source.available() ? this.source.available() : bufferSize;
                readed += readSize;
                byte[] bytes = this.source.reads(readSize);
                this.destination.write(bytes);
            }
            int n = readed;
            return n;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String forwardLine() throws IOException {
        this.streaming = true;
        try {
            String line = this.source.readLine();
            this.destination.writeLine(line);
            String string = line;
            return string;
        }
        finally {
            this.streaming = false;
        }
    }
}

