package org.phosphoresce.webcore.ext.struts.util;

import java.io.Serializable;
import java.lang.reflect.Method;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.config.ModuleConfig;
import org.phosphoresce.webcore.ext.struts.action.AbstractAction;
import org.phosphoresce.webcore.ext.struts.action.AbstractForm;
import org.phosphoresce.webcore.ext.struts.action.AbstractLogic;
import org.phosphoresce.webcore.ext.struts.annotation.StrutsAction;
import org.phosphoresce.webcore.ext.struts.annotation.StrutsForm;
import org.phosphoresce.webcore.ext.struts.annotation.StrutsLogic;
import org.phosphoresce.webcore.ext.struts.annotation.StrutsMethod;
import org.phosphoresce.webcore.ext.struts.enums.FormScope;

/**
 * Strutsモジュールアノテーションユーティリティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/07/04	Kitagawa		全体的に再構築
 *-->
 */
public final class StrutsAnnotationUtil {

	/**
	 * コンストラクタ<br>
	 */
	private StrutsAnnotationUtil() {
		super();
	}

	/**
	 * StrutsActionアノテーションを取得します。<br>
	 * @param actionClass アクションクラス
	 * @return StrutsActionアノテーション
	 */
	public static StrutsAction getStrutsActionAnnotation(Class<? extends AbstractAction<? extends Serializable, AbstractForm<? extends Serializable>>> actionClass) {
		if (actionClass == null) {
			return null;
		}
		return actionClass.getAnnotation(StrutsAction.class);
	}

	/**
	 * アクションに定義されたStrutsActionアノテーションを取得します。<br>
	 * @param action アクションオブジェクト
	 * @return StrutsFormアノテーション
	 */
	@SuppressWarnings("unchecked")
	public static StrutsAction getStrutsActionAnnotation(AbstractAction<? extends Serializable, AbstractForm<? extends Serializable>> action) {
		if (action == null) {
			return null;
		}
		return getStrutsActionAnnotation((Class<? extends AbstractAction<? extends Serializable, AbstractForm<? extends Serializable>>>) action.getClass());
	}

	/**
	 * StrutsFormアノテーションを取得します。<br>
	 * @param formClass フォームクラス
	 * @return StrutsFormアノテーション
	 */
	public static StrutsForm getStrutsFormAnnotation(Class<? extends AbstractForm<? extends Serializable>> formClass) {
		if (formClass == null) {
			return null;
		}
		return formClass.getAnnotation(StrutsForm.class);
	}

	/**
	 * StrutsFormアノテーションを取得します。<br>
	 * @param form フォームオブジェクト
	 * @return StrutsFormアノテーション
	 */
	@SuppressWarnings("unchecked")
	public static StrutsForm getStrutsFormAnnotation(AbstractForm<? extends Serializable> form) {
		if (form == null) {
			return null;
		}
		return getStrutsFormAnnotation((Class<? extends AbstractForm<? extends Serializable>>) form.getClass());
	}

	/**
	 * StrutsMethodアノテーションを取得します。<br>
	 * @param request リクエストオブジェクト
	 * @param moduleConfig モジュール環境オブジェクト
	 * @return StrutsMethodアノテーション
	 */
	public static StrutsMethod getStrutsMethodAnnotation(HttpServletRequest request, ModuleConfig moduleConfig, AbstractAction<? extends Serializable, ? extends AbstractForm<? extends Serializable>> action) {
		String actionPath = StrutsUtil.getRequestActionPath(request, moduleConfig);
		Method method = StrutsUtil.getActionMethod(actionPath);
		if (method == null) {
			return null;
		}
		return method.getAnnotation(StrutsMethod.class);
	}

	/**
	 * ロジッククラスに定義されたStrutsLogicアノテーションを取得します。<br>
	 * @param clazz アクションフォームクラス
	 * @return StrutsLogicアノテーション
	 */
	public static StrutsLogic getStrutsLogicAnnotation(Class<? extends AbstractLogic<? extends Serializable>> clazz) {
		if (clazz == null) {
			return null;
		}
		return clazz.getAnnotation(StrutsLogic.class);
	}

	/**
	 * アクションフォームのスコープを取得します。<br>
	 * @param clazz アクションフォームクラス
	 * @return アクションフォームスコープ
	 */
	public static FormScope getFormScope(Class<? extends AbstractForm<? extends Serializable>> clazz) {
		StrutsForm strutsForm = getStrutsFormAnnotation(clazz);
		if (strutsForm == null) {
			return null;
		}
		return strutsForm.scope();
	}

	/**
	 * アクションフォームのスコープを取得します。<br>
	 * @param form アクションフォームオブジェクト
	 * @return アクションフォームスコープ
	 */
	@SuppressWarnings("unchecked")
	public static FormScope getFormScope(AbstractForm<? extends Serializable> form) {
		if (form == null) {
			return null;
		}
		return getFormScope((Class<AbstractForm<? extends Serializable>>) form.getClass());
	}
}
