package org.phosphoresce.webcore.ext.struts.exception;

import java.io.Serializable;

import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.exception.WebcoreCriticalException;
import org.phosphoresce.webcore.ext.struts.StrutsConfigNames;
import org.phosphoresce.webcore.ext.struts.StrutsConstants;
import org.phosphoresce.webcore.ext.struts.action.AbstractForm;
import org.phosphoresce.webcore.ext.struts.action.ActionContext;
import org.phosphoresce.webcore.ext.struts.action.Forward;
import org.phosphoresce.webcore.ext.struts.action.MessageSet;

/**
 * Strutsアドオンモジュール致命的例外クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public abstract class StrutsModuleCriticalException extends WebcoreCriticalException implements StrutsConstants, StrutsModuleException {

	/**
	 * コンストラクタ<br>
	 */
	public StrutsModuleCriticalException() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param cause 例外要因
	 */
	public StrutsModuleCriticalException(String code, Throwable cause) {
		super(code, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param binds 例外メッセージバインドオブジェクト
	 * @param cause 例外要因
	 */
	public StrutsModuleCriticalException(String code, Object[] binds, Throwable cause) {
		super(code, binds, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 */
	public StrutsModuleCriticalException(String code) {
		super(code);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 * @param binds 例外メッセージバインドオブジェクト
	 */
	public StrutsModuleCriticalException(String code, Object[] binds) {
		super(code, binds);
	}

	/**
	 * アプリケーションメッセージを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return アプリケーションメッセージ
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleException#createApplicationMessage(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public <L extends Serializable, F extends AbstractForm<L>> MessageSet createApplicationMessage(ActionContext<L, F> actionContext) {
		MessageSet set = null;
		if (actionContext.isJSONReuqest()) {
			set = new MessageSet("FSTR00001");
		} else if (actionContext.isPopupRequest()) {
			set = new MessageSet("FSTR00001");
		} else {
			set = new MessageSet("FSTR00001");
		}
		return set;
	}

	/**
	 * 遷移用アクションフォワードを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return 遷移用アクションフォワード
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleException#createActionForward(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public <L extends Serializable, F extends AbstractForm<L>> Forward createActionForward(ActionContext<L, F> actionContext) {
		Forward forward = null;
		if (actionContext.isJSONReuqest()) {
			forward = null;
		} else if (actionContext.isPopupRequest()) {
			forward = new Forward();
			forward.setPath(JSP_SYSTEM_ERROR_PAGE);
			forward.setRedirect(false);
		} else {
			forward = new Forward();
			forward.setPath(JSP_SYSTEM_ERROR_PAGE);
			forward.setRedirect(false);
		}
		return forward;
	}

	/**
	 * レスポンスステータスを生成します。<br>
	 * @param actionContext アクションコンテキストオブジェクト
	 * @return レスポンスステータス(特別なステータスコードが不要であればnullを返却します)
	 * @see org.phosphoresce.webcore.ext.struts.exception.StrutsModuleException#createResponseStatus(org.phosphoresce.webcore.ext.struts.action.ActionContext)
	 */
	@Override
	public <L extends Serializable, F extends AbstractForm<L>> Integer createResponseStatus(ActionContext<L, F> actionContext) {
		if (Config.isEmpty(StrutsConfigNames.STRUTS_STATUS_EXCEPTION)) {
			return null;
		} else {
			return Config.getInteger(StrutsConfigNames.STRUTS_STATUS_EXCEPTION);
		}
	}
}
