package org.phosphoresce.webcore.ext.struts.enums;

/**
 * フォームスコープ列挙型クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public enum FormScope {

	/** リクエストスコープ */
	REQUEST("request"), //

	/** セッションスコープ */
	SESSION("session"), //

	;

	/** スコープ定義値 */
	private String value;

	/**
	 * コンストラクタ<br>
	 * @param value スコープ定義値
	 */
	private FormScope(String value) {
		this.value = value;
	}

	/**
	 * スコープ定義値を取得します。<br>
	 * @return スコープ定義値
	 */
	public String getValue() {
		return value;
	}
}
