package org.phosphoresce.webcore.ext.struts.config;

import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;

/**
 * モジュールコンフィグファクトリ拡張クラス<br>
 * <br>
 * 当クラスは標準のModuleConfigの代わりの拡張されたModuleConfigオブジェクトを提供します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 *-->
 */
public final class CustomModuleConfigFactory extends ModuleConfigFactory {

	/**
	 * 指定されたプレフィックスのModuleConfigインスタンスを生成します。<br>
	 * @see org.apache.struts.config.ModuleConfigFactory#createModuleConfig(java.lang.String)
	 */
	@Override
	public ModuleConfig createModuleConfig(String prefix) {
		return new CustomModuleConfig(prefix);
	}
}
