package org.phosphoresce.webcore.ext.struts.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.phosphoresce.webcore.ext.struts.enums.CacheReflectType;

/**
 * アクションメソッドアノテーション<br>
 * <br>
 * アクションクラスのイベントメソッドに付与して利用するアノテーションで、イベント処理挙動定義を行います。<br>
 * アクションメソッドは必ずこのアノテーションが定義されている必要があります。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/19	Kitagawa		新規作成
 * 2012/07/04	Kitagawa		全体的に再構築
 * 2012/11/07	Kitagawa		編集済み状態クリアフラグ追加
 * 2012/12/07	Kitagawa		トランザクショントークンチェックはディフォルト動作に変更
 *-->
 */
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.METHOD })
@Documented
public @interface StrutsMethod {

	/** キャッシュフォームフィールド反映 */
	public abstract CacheReflectType reflectCache() default CacheReflectType.MARKED_FIELD;

	/** フォームバリデーションメソッド */
	public abstract String validate() default "";

	/** バリデーションエラー時遷移ページ */
	public abstract String input() default "";

	/** データベーストランザクション管理クラス */
	public abstract StrutsTransaction[] transactions() default {};

	/** セッションタイムアウトチェックフラグ */
	public abstract boolean checkSesion() default true;

	/** ログインチェックフラグ */
	public abstract boolean checkLogin() default true;

	/** トークンチェックフラグ */
	public abstract boolean checkToken() default false;

	/** 編集済み状態クリアフラグ */
	public abstract boolean clearEdited() default false;

	/** ウィンドウスクロールクリアフラグ */
	public abstract boolean clearWindowScroll() default false;
}
