package org.phosphoresce.webcore.ext.struts;

import org.phosphoresce.webcore.core.ConfigName;
import org.phosphoresce.webcore.core.GlobalConstants;
import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.ext.struts.action.AbstractForm;
import org.phosphoresce.webcore.ext.struts.action.ServletContainer;
import org.phosphoresce.webcore.ext.struts.action.SessionContainer;
import org.phosphoresce.webcore.ext.struts.action.WindowSessionContainer;

/**
 * Strutsアドオン定数インタフェース<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public interface StrutsConstants extends GlobalConstants {

	/** JSPパス(システムエラーページ) */
	public static String JSP_SYSTEM_ERROR_PAGE = Config.getString(ConfigName.COMMON_JSP_SYSTEMERROR);

	/** JSPパス(メッセージページ) */
	public static String JSP_MESSAGE_PAGE = Config.getString(ConfigName.COMMON_JSP_PATH) + Config.getString(StrutsConfigNames.STRUTS_STATUS_EXCEPTION);

	/** アクションメソッドインタフェースシグネチャ */
	@SuppressWarnings("rawtypes")
	public static final Class[] ACTION_METHOD_SIGNATURE = new Class[] { AbstractForm.class, WindowSessionContainer.class, ServletContainer.class };

	/** セッションキー(コンテナ保持キー) */
	public static final String SESSION_KEY_CONTAINER = SessionContainer.class.getName();

	/** リクエストアトリビュートキー(セッションコンテナオブジェクト) */
	public static final String REQUEST_ATTR_KEY_SESSION_CONTAINER = "sessionContainer";

	/** リクエストアトリビュートキー(ウィンドウセッションオブジェクト) */
	public static final String REQUEST_ATTR_KEY_WINDOW_SESSION_CONTAINER = "windowSessionContainer";

	/** リクエストアトリビュートキー(画面データオブジェクト) */
	public static final String REQUEST_ATTR_KEY_SCREEN_DATA = "screenData";

	/** リクエストアトリビュートキー(アクションフォームオブジェクト) */
	public static final String REQUEST_ATTR_KEY_FORM = "form";

	/** リクエストアトリビュートキー(ダウンロードリリソースID) */
	public static final String REQUEST_ATTR_KEY_DOWNLOAD_ID = "downloadId";

	/** リクエストアトリビュートキー(ダウンロードファイル名) */
	public static final String REQUEST_ATTR_KEY_DOWNLOAD_FILENAME = "downloadName";

	/** フィールドキー(トークンID) */
	public static final String FIELD_KEY_TOKEN_ID = "controlFieldTokenId";

	/** フィールドキー(セッションID) */
	public static final String FIELD_KEY_SESSION_ID = "controlFieldSessionId";

	/** フィールドキー(ウィンドウID) */
	public static final String FIELD_KEY_WINDOW_ID = "controlFieldWindowId";

	/** フィールドキー(ポップアップウィンドウフラグ) */
	public static final String FIELD_KEY_POPUP_WINDOW = "controlFieldPopupWindow";

	/** フィールドキー(JSONリクエストフラグ) */
	public static final String FIELD_KEY_JSON_REQUEST = "controlFieldJsonRequest";

	/** フィールドキー(編集済みフラグ) */
	public static final String FIELD_KEY_FIELD_EDITED = "controlFieldEdited";

	/** フィールドキー(フォーカス位置退避情報) */
	public static final String FIELD_KEY_FOCUSED_ID = "controlFieldFocusedId";

	/** フィールドキー(ウィンドウスクロール位置(X)) */
	public static final String FIELD_KEY_WINDOW_SCROLL_X = "controlFieldWindowScrollX";

	/** フィールドキー(ウィンドウスクロール位置(Y)) */
	public static final String FIELD_KEY_WINDOW_SCROLL_Y = "controlFieldWindowScrollY";

	/** JSONキー(エラーメッセージ情報) */
	public static String JSON_KEY_ERROR_MESSAGES = "errorActionMessages";

	/** JSONキー(情報メッセージ情報) */
	public static String JSON_KEY_INFO_MESSAGES = "informationActionMessages";

	/** JSONキー(警告メッセージ情報) */
	public static String JSON_KEY_WARN_MESSAGES = "warningActionMessages";

	/** JSONキー(連絡メッセージ情報) */
	public static String JSON_KEY_NOTICE_MESSAGES = "noticeActionMessages";

	/** JSONキー(デバッグメッセージ情報) */
	public static String JSON_KEY_DEBUG_MESSAGES = "debugActionMessages";

	/** JSONキー(トレースメッセージ情報) */
	public static String JSON_KEY_TRACE_MESSAGES = "traceActionMessages";

	/** JSONキー(レスポンスオブジェクト情報) */
	public static String JSON_KEY_RESPONSE_DATA = "result";
}
