package org.phosphoresce.webcore.ext.smartlayout.taglib.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.phosphoresce.webcore.ext.smartlayout.model.SmartTagModel;

/**
 * 汎用カスタムタグ注釈クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/19	Kitagawa		新規作成
 *-->
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE })
public @interface LooseTagConfig {

	/** モデルクラス */
	public abstract Class<? extends SmartTagModel> modelClass();

	/** タグ出力処理フラグ */
	public abstract boolean output() default false;;
}
